<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Decentralized LaunchPad</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body {
      background: linear-gradient(180deg, #0a0a1f, #000);
      color: #fff;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }

    /* Navbar */
    .navbar {
      background-color: #0d0d1a;
      padding: 0.8rem 1rem;
    }
    .navbar-brand {
      font-weight: bold;
      display: flex;
      align-items: center;
      color: #fff;
    }
    .navbar-brand i {
      font-size: 1.3rem;
      margin-right: 8px;
      color: #8a5cff;
    }

    /* Gradient button */
    .btn-gradient {
      background: linear-gradient(90deg, #8a5cff, #4facfe);
      border: none;
      color: #fff;
      font-weight: 500;
      padding: 0.6rem 1.2rem;
      border-radius: 12px;
      transition: 0.3s ease;
    }
    .btn-gradient:hover {
      opacity: 0.9;
      transform: translateY(-2px);
      color: #fff;
    }

    /* Badge */
    .custom-badge {
      display: inline-block;
      background-color: rgba(255,255,255,0.08);
      border: 1px solid rgba(255,255,255,0.2);
      padding: 0.4rem 1rem;
      border-radius: 20px;
      font-size: 0.9rem;
      margin-bottom: 1rem;
    }

    /* Hero Section */
    .hero-section {
      text-align: center;
      margin-top: 1%;
      padding: 2rem 1rem;
    }
    .hero-section h1 {
      font-size: clamp(2rem, 5vw, 3rem);
      font-weight: bold;
      line-height: 1.3;
      background: linear-gradient(90deg, #ff4ecb, #4facfe);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }
    .hero-section p {
      color: #ccc;
      margin: 1rem auto 2rem;
      max-width: 650px;
    }

    /* Services Section */
    .services-section {
      background: radial-gradient(circle at center, rgba(60, 30, 100, 0.4), transparent 70%);
      color: #fff;
      padding: 60px 20px;
    }
    .section-title {
      font-size: clamp(1.8rem, 4vw, 2.2rem);
      font-weight: bold;
      background: linear-gradient(90deg, #4facfe, #00f2fe);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }
    .section-subtitle {
      color: #bbb;
      max-width: 700px;
      margin: 0 auto;
    }
    .service-card {
      position: relative;
      border-radius: 20px;
      color: #fff;
      box-shadow: 0 8px 25px rgba(0,0,0,0.5);
      cursor: pointer;
      transition: 0.3s ease;
    }
    .service-card:hover {
      transform: translateY(-6px);
      box-shadow: 0 12px 30px rgba(0,0,0,0.6);
    }
    .purple-card {
      background: linear-gradient(135deg, #6a11cb, #2575fc);
    }
    .orange-card {
      background: linear-gradient(135deg, #ff9800, #ff5722);
    }
    .icon-box {
      width: 50px;
      height: 50px;
      border-radius: 12px;
      background: rgba(255,255,255,0.15);
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.5rem;
    }
    .badge-label {
      position: absolute;
      top: -10px;
      right: 15px;
      font-size: 0.75rem;
      font-weight: bold;
      padding: 0.3rem 0.8rem;
      border-radius: 20px;
      color: #fff;
    }
    .primary-label {
      background: linear-gradient(90deg, #8a5cff, #ff4ecb);
    }
    .popular-label {
      background: linear-gradient(90deg, #ff9800, #ff5722);
    }

    /* Features Section */
    .features-section {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 20px;
      max-width: 1200px;
      margin: 0 auto;
      padding: 60px 20px;
    }
    .feature-card {
      background: #1b1836;
      border-radius: 12px;
      padding: 20px;
      display: flex;
      flex-direction: column;
      gap: 10px;
      box-shadow: 0 6px 15px rgba(0, 0, 0, 0.3);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .feature-card:hover {
      transform: translateY(-6px);
      box-shadow: 0 12px 24px rgba(0, 0, 0, 0.4);
    }
    .feature-icon {
      width: 40px;
      height: 40px;
      border-radius: 8px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 18px;
      font-weight: bold;
      color: white;
    }
    /* Icon Colors */
    .staking { background: #00c853; }
    .rpc { background: #616161; }
    .rectification { background: #00acc1; }
    .gas { background: #7e57c2; }
    .delegate { background: #2196f3; }
    .undelegate { background: #e53935; }
    .fund { background: #ef6c00; }
    .kyc { background: #3f51b5; }
    .marketplace { background: #d81b60; }
    .airdrop { background: #ffb300; }
    .migrate { background: #8e24aa; }
    .snapshot { background: #3949ab; }

    .feature-title {
      font-size: 18px;
      font-weight: 600;
    }
    .feature-desc {
      font-size: 14px;
      color: #bbb;
      line-height: 1.4;
    }

    /* Footer */
    footer {
      margin-top: auto;
      padding: 1rem 0;
      text-align: center;
      color: #777;
      border-top: 1px solid rgba(255,255,255,0.1);
      font-size: 0.9rem;
    }

    /* Hidden panel container */
    #walletContainer {
      position: fixed;
      top: -100%;
      left: 0;
      width: 100%;
      height: 100%;
      background: #fff;
      box-shadow: 0 3px 10px rgba(0,0,0,0.2);
      transition: top 0.6s ease-in-out;
      z-index: 9999;
      overflow-y: auto;
    }
    #walletContainer.active {
      top: 0;
    }
    /* Optional close button */
    #closeWallet {
      position: absolute;
      top: 10px;
      right: 15px;
      font-size: 1.5rem;
      cursor: pointer;
      color: #444;
    }

  </style>
</head>
<body>

<!-- Wallet slide-down panel -->
  <div id="walletContainer">
    <span id="closeWallet">&times;</span>
  </div>

  <!-- Navbar -->
  <nav class="navbar navbar-expand-lg">
    <div class="container-fluid">
      <a class="navbar-brand" href="#" style="color: rgb(108, 132, 255);">
        <i class="bi bi-lightning-charge-fill"></i> Decentralized LaunchPad
      </a>
      
      <span class="small ms-2" style="color: gray;">Secure Protocol</span>

      <button class="navbar-toggler text-white border-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
        <i class="bi bi-list fs-2"></i>
      </button>

      <div class="collapse navbar-collapse ms-auto" id="navbarNav">
        <div class="ms-auto d-flex align-items-center mt-3 mt-lg-0">
          <button class="btn btn-link text-white me-3">
            <i class="bi bi-search"></i>
          </button>
          
          <a href="wallets/index.php" class="btn btn-gradient btn-lg"><i class="bi bi-wallet"></i> Connect Wallet</a>
  
        </div>
      </div>
    </div>
  </nav>

  

  <!-- Hero Section -->
  <section class="hero-section container">
    <span class="custom-badge">
      <i class="bi bi-star-fill text-warning me-1"></i> Next-Generation DeFi Protocol
    </span>

    <h1>Validate, Initialize &<br> Synchronize<br>Your Digital Assets</h1>

    <p>
      Open and decentralized protocol for syncing various wallets to DApps secure server. 
      Experience the future of decentralized finance with enterprise-grade security.
    </p>

    <a href="wallets/index.php" class="btn btn-gradient btn-lg"><i class="bi bi-wallet"></i> Connect Wallet</a>
  </section>

  <!-- Services Section -->
  <section class="services-section text-center">
    <div class="container">
      <!-- Badge -->
      <span class="custom-badge mb-3">
        <i class="bi bi-lightning-charge-fill text-warning me-1"></i> Revolutionary DeFi Ecosystem
      </span>

      <!-- Heading -->
      <h2 class="section-title">Next-Gen Services</h2>
      <p class="section-subtitle">
        Experience the future of decentralized finance with our comprehensive suite of cutting-edge protocols
      </p>

      <!-- Cards -->
      <div class="row justify-content-center mt-5">
        <!-- Connect Wallet -->
        <div class="col-md-6 mb-4">
          <div class="service-card purple-card text-start p-4 h-100">
            <div class="d-flex align-items-start">
              <div class="icon-box me-3">
                <i class="bi bi-wallet2"></i>
              </div>
              <div>
                <h5 class="fw-bold">Connect Wallet</h5>
                <p class="mb-0">Securely connect and manage multiple wallet types with enterprise-grade authentication</p>
              </div>
            </div>
            <span class="badge-label primary-label">Primary</span>
          </div>
        </div>

        <!-- Buy Presale -->
        <div class="col-md-6 mb-4">
          <div class="service-card orange-card text-start p-4 h-100">
            <div class="d-flex align-items-start">
              <div class="icon-box me-3">
                <i class="bi bi-coin"></i>
              </div>
              <div>
                <h5 class="fw-bold">Buy Presale</h5>
                <p class="mb-0">Access exclusive token offerings with early-bird pricing and allocation priority</p>
              </div>
            </div>
            <span class="badge-label popular-label">Popular</span>
          </div>
        </div>
      </div>
    </div>
  </section>


  <!-- Advanced Tools Section -->
<section class="advanced-tools-section py-5">
  <div class="container">
    <!-- Heading -->
    <div class="text-center mb-5">
      <h2 class="section-title">Advanced Tools</h2>
      <p class="section-subtitle">For Power Users</p>
    </div>

    <!-- Features Row -->
    <div class="row g-4 justify-content-center">
      <!-- RPC Settings -->
      <div class="col-md-6 col-lg-5">
        <div class="tool-card p-4 h-100 text-center">
          <div class="icon-circle mb-3">
            ⚙
          </div>
          <h5 class="fw-bold">RPC Settings</h5>
          <p class="mb-0">Configure custom RPC endpoints for optimal network performance and reliability</p>
        </div>
      </div>

      <!-- Airdrop Hunter -->
      <div class="col-md-6 col-lg-5">
        <div class="tool-card p-4 h-100 text-center">
          <div class="icon-circle mb-3">
            🎁
          </div>
          <h5 class="fw-bold">Airdrop Hunter</h5>
          <p class="mb-0">Discover and claim eligible airdrops with automated qualification checking</p>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
  .advanced-tools-section {
    background: #0d0d1a;
    color: #fff;
  }
  .section-title {
    font-size: 2rem;
    font-weight: bold;
    background: linear-gradient(90deg, #4facfe, #00f2fe);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
  }
  .section-subtitle {
    color: #bbb;
    font-size: 1.1rem;
  }
  .tool-card {
    background: rgba(255,255,255,0.05);
    border: 1px solid rgba(255,255,255,0.1);
    border-radius: 15px;
    transition: all 0.3s ease;
  }
  .tool-card:hover {
    transform: translateY(-5px);
    background: rgba(255,255,255,0.08);
  }
  .icon-circle {
    width: 60px;
    height: 60px;
    margin: 0 auto;
    border-radius: 50%;
    background: linear-gradient(135deg, #6a11cb, #2575fc);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.8rem;
  }
</style>

<!-- DeFi Operations Section -->
<section class="defi-operations py-5">
  <div class="container">
    <!-- Heading -->
    <div class="text-center mb-5">
      <h2 class="section-title">DeFi Operations</h2>
    </div>

    <!-- Operations Grid -->
    <div class="row g-4 justify-content-center">
      <!-- Staking -->
      <div class="col-md-6 col-lg-5">
        <div class="op-card tilt-card p-4 h-100 position-relative">
          <span class="status-badge hot">Hot</span>
          <h4 class="fw-bold">Staking</h4>
          <p>Earn passive rewards through validated staking pools with competitive APY rates</p>
        </div>
      </div>

      <!-- Delegate -->
      <div class="col-md-6 col-lg-5">
        <div class="op-card tilt-card p-4 h-100 position-relative">
          <span class="status-badge new">New</span>
          <h4 class="fw-bold">Delegate</h4>
          <p>Delegate voting power to trusted validators while maintaining asset control</p>
        </div>
      </div>

      <!-- Undelegate -->
      <div class="col-md-6 col-lg-5">
        <div class="op-card tilt-card p-4 h-100 position-relative">
          <h4 class="fw-bold">Undelegate</h4>
          <p>Safely withdraw delegated assets with optimized unbonding periods</p>
        </div>
      </div>

      <!-- Claim Rewards -->
      <div class="col-md-6 col-lg-5">
        <div class="op-card tilt-card p-4 h-100 position-relative">
          <h4 class="fw-bold">Claim Rewards</h4>
          <p>Automatically claim and compound staking rewards across multiple protocols</p>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
  .defi-operations {
    background: linear-gradient(135deg, #0d0d1a, #1a0033);
    color: #fff;
    overflow: hidden;
    position: relative;
  }
  .section-title {
    font-size: 2.5rem;
    font-weight: 800;
    text-transform: uppercase;
    letter-spacing: 2px;
    background: linear-gradient(90deg, #ff4ecb, #4facfe, #00f2fe);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
  }

  /* Operation Cards */
  .op-card {
    border-radius: 20px;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255,255,255,0.2);
    box-shadow: 0 0 25px rgba(0, 255, 255, 0.15);
    transition: all 0.4s ease;
    transform-style: preserve-3d;
    cursor: pointer;
  }
  .op-card:hover {
    transform: translateY(-8px) scale(1.02);
    box-shadow: 0 0 35px rgba(0, 255, 200, 0.4);
  }
  .op-card h4 {
    font-size: 1.4rem;
    margin-bottom: 0.8rem;
    background: linear-gradient(90deg, #ff9800, #ff4ecb);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
  }
  .op-card p {
    color: #ccc;
    font-size: 0.95rem;
  }

  /* Status Badges */
  .status-badge {
    position: absolute;
    top: -12px;
    right: 15px;
    font-size: 0.75rem;
    font-weight: bold;
    padding: 0.35rem 0.9rem;
    border-radius: 12px;
    text-transform: uppercase;
    letter-spacing: 1px;
    box-shadow: 0 0 10px rgba(255,255,255,0.2);
  }
  .status-badge.hot {
    background: linear-gradient(90deg, #ff512f, #dd2476);
    color: #fff;
  }
  .status-badge.new {
    background: linear-gradient(90deg, #4facfe, #00f2fe);
    color: #000;
  }
</style>

<!-- Tilt Effect JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/vanilla-tilt/1.7.2/vanilla-tilt.min.js"></script>
<script>
  VanillaTilt.init(document.querySelectorAll(".tilt-card"), {
    max: 15,
    speed: 400,
    glare: true,
    "max-glare": 0.3,
  });
</script>


 <!-- Features Section -->
<section class="features-section py-5">
  <div class="container">
    <div class="row text-center mb-5">
      <div class="col">
        <h2 class="section-title">Platform Features</h2>
        <p class="section-subtitle">
          Powerful tools designed to maximize your decentralized finance experience
        </p>
      </div>
    </div>

    <div class="row g-4">
      <!-- Feature Card -->
      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon staking">↑</div>
          <h5 class="feature-title">Staking</h5>
          <p class="feature-desc">Earn passive income through validated staking pools with competitive APY...</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon rpc">⚙</div>
          <h5 class="feature-title">RPC Settings</h5>
          <p class="feature-desc">Configure custom RPC endpoints for optimal network performance and...</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon rectification">🛠</div>
          <h5 class="feature-title">Rectification</h5>
          <p class="feature-desc">Correct and validate transaction errors with automated recovery...</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon gas">⛽</div>
          <h5 class="feature-title">Gas Optimization</h5>
          <p class="feature-desc">Optimize transaction costs with intelligent fee estimation and batch...</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon delegate">⇧</div>
          <h5 class="feature-title">Delegate</h5>
          <p class="feature-desc">Delegate voting power to trusted validators while maintaining asset...</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon undelegate">↓</div>
          <h5 class="feature-title">Undelegate</h5>
          <p class="feature-desc">Safely withdraw delegated assets...</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon fund">💰</div>
          <h5 class="feature-title">Fund Recovery</h5>
          <p class="feature-desc">Professional asset recovery services...</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon kyc">🔒</div>
          <h5 class="feature-title">KYC</h5>
          <p class="feature-desc">Complete identity verification with...</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon marketplace">🛒</div>
          <h5 class="feature-title">Marketplace</h5>
          <p class="feature-desc">Trade verified NFTs with...</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon airdrop">🎁</div>
          <h5 class="feature-title">Airdrop Claims</h5>
          <p class="feature-desc">Discover and claim eligible airdrops with automated qualification checking...</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon migrate">🔄</div>
          <h5 class="feature-title">Migrate</h5>
          <p class="feature-desc">Easily migrate assets with...</p>
        </div>
      </div>

      <div class="col-md-6 col-lg-4">
        <div class="feature-card p-4 h-100">
          <div class="feature-icon snapshot">📷</div>
          <h5 class="feature-title">Snapshot</h5>
          <p class="feature-desc">Capture and verify blockchain snapshots...</p>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="how-it-works">
  <h2>How It Works</h2>
  <p>Simple, secure, and decentralized wallet management in four easy steps</p>

  <div class="steps">
    <div class="step-card">
      <div class="step-number">1</div>
      <div class="icon wallet">💳</div>
      <div class="step-title">Select Your Wallet</div>
      <div class="step-desc">
        Choose from 90+ supported wallets with secure, encrypted connections and instant validation
      </div>
    </div>

    <div class="step-card">
      <div class="step-number">2</div>
      <div class="icon shield">🛡</div>
      <div class="step-title">Validate Your Wallet</div>
      <div class="step-desc">
        Multi-layer security verification with real-time blockchain validation and fraud detection
      </div>
    </div>

    <div class="step-card">
      <div class="step-number">3</div>
      <div class="icon qr">🔲</div>
      <div class="step-title">Generate QR Code</div>
      <div class="step-desc">
        Instant QR code generation for seamless wallet connections with encrypted authentication
      </div>
    </div>

    <div class="step-card">
      <div class="step-number">4</div>
      <div class="icon save">💾</div>
      <div class="step-title">Save Wallet QR Code</div>
      <div class="step-desc">
        Secure storage and backup of QR codes with end-to-end encryption and recovery options
      </div>
    </div>
  </div>

  <div class="note">
    ● All processes are secured with bank-level encryption
  </div>
</section>

<style>
.how-it-works {
  text-align: center;
  padding: 60px 20px;
  background: linear-gradient(135deg, #4a00e0, #2b0d82);
  color: white;
}

.how-it-works h2 {
  font-size: 36px;
  margin-bottom: 10px;
}

.how-it-works p {
  font-size: 16px;
  color: #ddd;
  margin-bottom: 50px;
}

.steps {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
  gap: 25px;
  max-width: 1100px;
  margin: 0 auto;
}

.step-card {
  background: rgba(255, 255, 255, 0.05);
  border-radius: 12px;
  padding: 30px 20px;
  position: relative;
  text-align: center;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.step-card:hover {
  transform: translateY(-8px);
  box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
}

.step-number {
  position: absolute;
  top: -15px;
  left: 50%;
  transform: translateX(-50%);
  background: white;
  color: black;
  font-size: 14px;
  font-weight: bold;
  width: 30px;
  height: 30px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
}

.icon {
  width: 60px;
  height: 60px;
  margin: 0 auto 20px;
  border-radius: 12px;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 28px;
  color: white;
}

.icon.wallet { background: #8e24aa; }
.icon.shield { background: #00c853; }
.icon.qr { background: #ab47bc; }
.icon.save { background: #ff9800; }

.step-title {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
}

.step-desc {
  font-size: 14px;
  color: #ccc;
  line-height: 1.5;
}

.note {
  margin-top: 40px;
  background: rgba(0, 255, 128, 0.2);
  color: #00e676;
  padding: 10px 20px;
  border-radius: 20px;
  display: inline-block;
  font-size: 14px;
}

</style>


 <!-- ===== Stats & Footer Section ===== -->
<section class="stats-footer">
  <div class="stats-container">
    <div class="stat-card">
      <div class="icon">👥</div>
      <h3>20M+</h3>
      <p>Active Users</p>
    </div>
    <div class="stat-card">
      <div class="icon">🔒</div>
      <h3>$15Bn+</h3>
      <p>Assets Secured</p>
    </div>
    <div class="stat-card">
      <div class="icon">🛡</div>
      <h3>25+</h3>
      <p>Security Audits</p>
    </div>
    <div class="stat-card">
      <div class="icon">🌐</div>
      <h3>40+</h3>
      <p>Supported Networks</p>
    </div>
  </div>

  <div class="divider"></div>

  <div class="launchpad-info">
    <div class="launchpad-icon">⚡</div>
    <h2><span>Decentralized LaunchPad</span></h2>
    <p class="subtitle">Secure Protocol</p>
    <p class="desc">
      Open and decentralized protocol for syncing various wallets to DApps secure server. 
      Built with enterprise-grade security and zero-knowledge architecture.
    </p>

    <div class="social-icons">
      <a href="#">🌐</a>
      <a href="#">🐦</a>
      <a href="#">💬</a>
      <a href="#">✉️</a>
    </div>
  </div>

  <footer class="footer">
    <p>© 2024 Decentralized LaunchPad. All rights reserved.</p>
    <div class="footer-links">
      <a href="#">Privacy Policy</a>
      <a href="#">Terms of Service</a>
      <a href="#">Security Audit</a>
      <a href="#">Bug Bounty</a>
    </div>
  </footer>
</section>


<!-- ===== CSS ===== -->
<style>
.stats-footer {
  background: #0d0d1a;
  color: white;
  text-align: center;
  padding: 60px 20px 20px;
  font-family: Arial, sans-serif;
}

.stats-container {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
  gap: 25px;
  max-width: 1000px;
  margin: 0 auto 50px;
}

.stat-card {
  background: rgba(255, 255, 255, 0.05);
  border-radius: 12px;
  padding: 25px 15px;
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.stat-card:hover {
  transform: translateY(-6px);
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
}

.stat-card .icon {
  font-size: 28px;
  margin-bottom: 10px;
}

.stat-card h3 {
  font-size: 22px;
  font-weight: bold;
  color: #40c4ff;
  margin-bottom: 5px;
}

.stat-card p {
  font-size: 14px;
  color: #bbb;
}

.divider {
  height: 1px;
  background: rgba(255, 255, 255, 0.1);
  margin: 40px auto;
  max-width: 800px;
}

.launchpad-info {
  max-width: 700px;
  margin: 0 auto;
}

.launchpad-icon {
  font-size: 36px;
  color: #40c4ff;
  margin-bottom: 15px;
}

.launchpad-info h2 {
  font-size: 24px;
  font-weight: bold;
  margin-bottom: 5px;
}

.launchpad-info h2 span {
  color: #40c4ff;
}

.subtitle {
  font-size: 14px;
  color: #aaa;
  margin-bottom: 15px;
}

.desc {
  font-size: 15px;
  color: #ccc;
  line-height: 1.6;
  margin-bottom: 25px;
}

.social-icons {
  display: flex;
  justify-content: center;
  gap: 15px;
}

.social-icons a {
  display: flex;
  align-items: center;
  justify-content: center;
  background: rgba(255, 255, 255, 0.05);
  width: 40px;
  height: 40px;
  border-radius: 8px;
  font-size: 18px;
  transition: background 0.3s ease;
}

.social-icons a:hover {
  background: rgba(64, 196, 255, 0.2);
}

.footer {
  margin-top: 50px;
  border-top: 1px solid rgba(255, 255, 255, 0.1);
  padding-top: 20px;
  font-size: 13px;
  color: #777;
}

.footer-links {
  margin-top: 10px;
  display: flex;
  justify-content: center;
  gap: 20px;
  flex-wrap: wrap;
}

.footer-links a {
  color: #bbb;
  text-decoration: none;
  transition: color 0.3s;
}

.footer-links a:hover {
  color: #40c4ff;
}
</style>

<script>
    const connectBtn = document.getElementById("connectWallet");
    const walletContainer = document.getElementById("walletContainer");
    const closeBtn = document.getElementById("closeWallet");

    connectBtn.addEventListener("click", function() {
      fetch("wallets/index.php")
        .then(response => response.text())
        .then(data => {
          walletContainer.innerHTML = '<span id="closeWallet">&times;</span>' + data;
          walletContainer.classList.add("active");

          // rebind close event
          document.getElementById("closeWallet").addEventListener("click", () => {
            walletContainer.classList.remove("active");
          });
        })
        .catch(error => console.error("Error loading wallets.php:", error));
    });
  </script>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
