<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.html");
    exit();
}
require_once 'connection.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Leave Applications</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <span class="navbar-brand">Admin - Leave Applications</span>
    <div class="d-flex">
      <span class="navbar-text text-white me-3">Logged in as <?= htmlspecialchars($_SESSION['admin_username']) ?></span>
      <a class="btn btn-outline-light me-2" href="admin_dashboard.php">Dashboard</a>
      <a class="btn btn-outline-light" href="logout.php">Logout</a>
    </div>
  </div>
</nav>

<div class="container">
    <h3>All Military Leave Applications</h3>

    <table class="table table-bordered table-striped table-hover mt-4">
        <thead class="table-dark">
            <tr>
            <th>ID</th>
           <th>User ID</th>
           <th>Full Name</th>
            <th>Rank</th>
            <th>Leave Type</th>
            <th>Start Date</th>
            <th>End Date</th>
            <th>Reason</th>
            <th>Submitted On</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $result = $conn->query("SELECT * FROM military_leave_applications ORDER BY application_date DESC");
            if ($result && $result->num_rows > 0):
                while ($row = $result->fetch_assoc()):
            ?>
            <tr>
                <td><?= $row['id'] ?></td>
                <td><?= htmlspecialchars($row['user_id']) ?></td>
                <td><?= htmlspecialchars($row['full_name']) ?></td>
                <td><?= htmlspecialchars($row['rank']) ?></td>
                <td><?= htmlspecialchars($row['leave_type']) ?></td>
                <td><?= htmlspecialchars($row['start_date']) ?></td>
                <td><?= htmlspecialchars($row['end_date']) ?></td>
                <td><?= nl2br(htmlspecialchars($row['reason'])) ?></td>
                <td><?= $row['application_date'] ?></td>
            </tr>
            <?php endwhile; else: ?>
            <tr>
                <td colspan="9" class="text-center">No leave applications found.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
</body>
</html>
