<?php
require_once '../connection.php';

$query = '';
$results = [];

if ($_SERVER["REQUEST_METHOD"] === "POST" && !empty($_POST['query'])) {
    $query = trim($_POST['query']);

    // Search by user_id, name, or remarks
    $stmt = $conn->prepare("SELECT * FROM employee_records WHERE user_id LIKE ? OR name LIKE ? OR remarks LIKE ?");
    $search_term = "%" . $query . "%";
    $stmt->bind_param("sss", $search_term, $search_term, $search_term);
    $stmt->execute();
    $results = $stmt->get_result();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Search Profiles</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)),
                  url('https://api.army.mil/e2/c/images/2020/10/01/d81be2e8/size0.jpg') no-repeat center center fixed;
      background-size: cover;
      color: #f8f9fa;
      font-family: 'Segoe UI', sans-serif;
    }

    .logo {
      width: 150px;
      display: block;
      margin: 30px auto 10px auto;
    }

    .search-box {
      max-width: 600px;
      margin: 0 auto 30px auto;
    }

    .form-control,
    .btn {
      border-radius: 0.375rem;
    }

    .table-container {
      background: rgba(0, 0, 0, 0.6);
      padding: 30px;
      border-radius: 10px;
    }

    .table td,
    .table th {
      color: #fff;
    }

    img.thumb {
      width: 60px;
      height: 60px;
      object-fit: cover;
      border-radius: 4px;
    }

    .alert {
      max-width: 600px;
      margin: 20px auto;
    }
  </style>
</head>
<body>

  <!-- Logo -->
  <a href="index.html">
  <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRsjedvRI6i6MeA9Hz43KhCER4a22DyWpJ_yA&s" style="width: 100px; height: 100px; border-radius: 100px;" alt="Logo" class="logo">
  </a>

  <!-- Search Form -->
  <div class="search-box text-center">
    <h3>Search Profiles</h3>
    <form action="search.php" method="POST" class="d-flex justify-content-center gap-2 mt-4">
      <input autocomplete="off" name="query" placeholder="Search by name, user ID, or remarks" class="form-control" style="width: 70%;" value="<?= htmlspecialchars($query) ?>">
      <button type="submit" class="btn btn-primary" style="background-color: black; border: none;">Search</button>
    </form>
  </div>

  <!-- Results -->
  <div class="container mt-4 table-container">
    <?php if ($_SERVER["REQUEST_METHOD"] === "POST"): ?>
      <?php if ($results && $results->num_rows > 0): ?>
        <table class="table table-bordered table-hover">
          <thead class="table-dark">
            <tr>
              <th>ID</th>
              <th>User ID</th>
              <th>Name</th>
              <th>DOB</th>
              <th>Years</th>
              <th>Remarks</th>
              <th>Photo</th>
              <th>Created</th>
            </tr>
          </thead>
          <tbody>
          <?php while ($row = $results->fetch_assoc()): ?>
            <tr style="color: black;">
              <td style="color: black;"><?= $row['id'] ?></td>
              <td style="color: black;"><?= htmlspecialchars($row['user_id']) ?></td>
              <td style="color: black;"><?= htmlspecialchars($row['name']) ?></td>
              <td style="color: black;"><?= htmlspecialchars($row['dob']) ?></td>
              <td style="color: black;"><?= $row['years_of_service'] ?></td>
              <td style="color: black;"><?= htmlspecialchars($row['remarks']) ?></td>
              <td style="color: black;">
                <?php if ($row['photo'] && file_exists($row['photo'])): ?>
                  <img src="<?= $row['photo'] ?>" class="thumb">
                <?php else: ?>
                  N/A
                <?php endif; ?>
              </td>
              <td style="color: black;"><?= $row['created_at'] ?></td>
            </tr>
          <?php endwhile; ?>
          </tbody>
        </table>
      <?php else: ?>
        <div class="alert alert-warning text-dark text-center">
          No matching profiles found for <strong><?= htmlspecialchars($query) ?></strong>.
        </div>
      <?php endif; ?>
    <?php endif; ?>
  </div>

</body>
</html>
