<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.html");
    exit();
}
require_once 'connection.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard</title>
    <!-- Bootstrap CSS CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        img.thumb {
            width: 60px;
            height: 60px;
            object-fit: cover;
            border-radius: 5px;
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <span class="navbar-brand">Admin</span>
    <div class="d-flex">
      <span class="navbar-text text-white me-3">Logged in as <?= htmlspecialchars($_SESSION['admin_username']) ?></span>
      <a class="btn btn-outline-light" href="view_leave_applications.php">Leave Applications</a>
      <a class="btn btn-outline-light" href="logout.php">Logout</a>
    </div>
  </div>
</nav>

<div class="container mt-5">
    <h3>Add Profile</h3>
    <form action="add_employee.php" method="POST" enctype="multipart/form-data" class="row g-3 mt-3">
        <div class="col-md-6">
            <label for="user_id" class="form-label">User ID</label>
            <input type="text" name="user_id" class="form-control" required>
        </div>
        <div class="col-md-6">
            <label for="name" class="form-label">Full Name</label>
            <input type="text" name="name" class="form-control" required>
        </div>
        <div class="col-md-6">
            <label for="dob" class="form-label">Date of Birth</label>
            <input type="date" name="dob" class="form-control" required>
        </div>
        <div class="col-md-6">
            <label for="years_of_service" class="form-label">Years of Service</label>
            <input type="number" name="years_of_service" class="form-control" required>
        </div>
        <div class="col-md-12">
            <label for="remarks" class="form-label">Remarks</label>
            <textarea name="remarks" class="form-control" rows="3"></textarea>
        </div>
        <div class="col-md-12">
            <label for="photo" class="form-label">Photo</label>
            <input type="file" name="photo" class="form-control" accept="image/*">
        </div>
        <div class="col-12">
            <button type="submit" class="btn btn-primary">Add Record</button>
        </div>
    </form>
</div>

<!-- Display Table Section -->
<div class="container mt-5">
    <h3>All Employee Records</h3>
    <table class="table table-bordered table-striped align-middle mt-3">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>User ID</th>
                <th>Name</th>
                <th>DOB</th>
                <th>Years</th>
                <th>Remarks</th>
                <th>Photo</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php
        $records = $conn->query("SELECT * FROM employee_records ORDER BY created_at DESC");
        if ($records && $records->num_rows > 0):
            while ($row = $records->fetch_assoc()):
        ?>
            <tr>
                <td><?= $row['id'] ?></td>
                <td><?= htmlspecialchars($row['user_id']) ?></td>
                <td><?= htmlspecialchars($row['name']) ?></td>
                <td><?= htmlspecialchars($row['dob']) ?></td>
                <td><?= htmlspecialchars($row['years_of_service']) ?></td>
                <td><?= htmlspecialchars($row['remarks']) ?></td>
                <td>
                    <?php if ($row['photo']): ?>
                        <img src="<?= htmlspecialchars($row['photo']) ?>" class="thumb">
                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                </td>
                <td>
                    <a href="edit_employee.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                    <a href="delete_employee.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger"
                       onclick="return confirm('Are you sure you want to delete this record?');">Delete</a>
                </td>
            </tr>
        <?php endwhile; else: ?>
            <tr>
                <td colspan="8" class="text-center">No records found.</td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Bootstrap JS CDN -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
