<?php
    $contactContent = getContent('contact.content', true);
?>

<?php $__env->startSection('content'); ?>
    <div class="container section">
        <div class="row gy-5 gy-md-0 gx-xl-5 align-items-center flex-wrap-reverse">
            <div class="col-lg-6 col-xl-5">
                <ul class="list list--column">
                    <li class="list--column__item-xl">
                        <div class="d-flex align-items-center bg--light-1 p-3 p-lg-4">
                            <div class="flex-shrink-0 contact-icon-box--primary">
                                <i class="las la-street-view"></i>
                            </div>
                            <div class="ms-5">
                                <p class="mb-2 fw-bold text-capitalize t-text-heading xl-text">
                                    <?php echo app('translator')->get('Office Address'); ?>
                                </p>
                                <p class="mb-0"><?php echo e(__($contactContent->data_values->location)); ?></p>
                            </div>
                        </div>
                    </li>
                    <li class="list--column__item-xl">
                        <div class="d-flex align-items-center bg--light-1 p-3 p-lg-4">
                            <div class="flex-shrink-0 contact-icon-box--primary">
                                <i class="las la-envelope-open-text"></i>
                            </div>
                            <div class="ms-5">
                                <p class="mb-2 fw-bold text-capitalize t-text-heading xl-text">
                                    <?php echo app('translator')->get('Email Address'); ?>
                                </p>
                                <p class="mb-0"><?php echo e(__($contactContent->data_values->email)); ?></p>
                            </div>
                        </div>
                    </li>
                    <li class="list--column__item-xl">
                        <div class="d-flex align-items-center bg--light-1 p-3 p-lg-4">
                            <div class="flex-shrink-0 contact-icon-box--primary">
                                <i class="las la-phone-volume"></i>
                            </div>
                            <div class="ms-5">
                                <p class="mb-2 fw-bold text-capitalize t-text-heading xl-text">
                                    <?php echo app('translator')->get('Mobile Number'); ?>
                                </p>
                                <p class="mb-0"><?php echo e(__($contactContent->data_values->phone)); ?></p>
                            </div>
                        </div>
                    </li>

                </ul>
            </div>
            <div class="col-lg-6 col-xl-7">
                <div class="query bg--light-1">
                    <h3 class="query__title text-center text-md-start text-capitalize mt-0">
                        <?php echo e(__(@$contactContent->data_values->heading)); ?>

                    </h3>
                    <form method="post" action="" class="row g-4 verify-gcaptcha">
                        <?php echo csrf_field(); ?>
                        <div class=" col-sm-6 col-lg-12 col-xl-6">
                            <input type="text" name="name"
                                class="form-control form-control-custom form-control-custom--outline form-control-custom--outline-dark"
                                value="<?php echo e(old('name', @$user->fullname)); ?>"
                                <?php if($user): ?> readonly <?php endif; ?> placeholder="<?php echo app('translator')->get('Your Name'); ?>"
                                required />
                        </div>
                        <div class=" col-sm-6 col-lg-12 col-xl-6">
                            <input type="email" name="email"
                                class="form-control form-control-custom form-control-custom--outline form-control-custom--outline-dark"
                                value="<?php echo e(old('email', @$user->email)); ?>" <?php if($user): ?> readonly <?php endif; ?>
                                placeholder="<?php echo app('translator')->get('Email address'); ?>" required />
                        </div>
                        <div class="col-12">
                            <input type="text" name="subject"
                                class="form-control form-control-custom form-control-custom--outline form-control-custom--outline-dark"
                                value="<?php echo e(old('subject')); ?>" placeholder="<?php echo app('translator')->get('Subject'); ?>" required />
                        </div>

                        <div class="col-12">
                            <textarea cols="30" rows="5" wrap="off" name="message"
                                class="form-control form-control-custom--outline form-control-custom--dark" placeholder="<?php echo app('translator')->get('Write Your Message'); ?>"
                                required><?php echo e(old('message')); ?></textarea>
                        </div>
                        <div class="col-12">
                            <?php if (isset($component)) { $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243 = $component; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Captcha::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243)): ?>
<?php $component = $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243; ?>
<?php unset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243); ?>
<?php endif; ?>
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn--xl btn--base text-capitalize">
                                <?php echo app('translator')->get('Send Message'); ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="pt-5">
            <?php if($sections->secs != null): ?>
                <?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo $__env->make($activeTemplate . 'sections.' . $sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
    </div>

    <div class="container-fluid p-0">
        <div class="row g-0">
            <div class="col-12">
                <div class="gmap">
                    <iframe src="<?php echo @$contactContent->data_values->map ?>"></iframe>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .form--control {
            padding: 22px !important;
            border: 1px solid #e9e9e9 !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ultimatx/public_html/eleonagroupintl.com/core/resources/views/templates/basic/contact.blade.php ENDPATH**/ ?>