<?php $__env->startSection('content'); ?>
    <div class="dashboard-inner">
        <?php if($user->loans->where('status', Status::LOAN_RUNNING)->count() == 1): ?>
            <div class="alert border border--warning" role="alert">
                <div class="alert__icon d-flex align-items-center text--success"><i class="fas fa-check"></i></div>
                <p class="alert__message">
                    <span class="fw-bold"><?php echo app('translator')->get('First Loan'); ?></span><br>
                    <small><i><span class="fw-bold"><?php echo app('translator')->get('Congratulations!'); ?></span> <?php echo app('translator')->get('You\'ve made your first loan successfully. Go to'); ?> <a
                                href="<?php echo e(route('user.loan.plans')); ?>" class="link-color"><?php echo app('translator')->get('Loan List'); ?></a>
                            <?php echo app('translator')->get('for see your next installment date at near.'); ?></i></small>
                </p>
            </div>
        <?php endif; ?>

        <?php if($pendingWithdrawals): ?>
            <div class="alert border border--primary" role="alert">
                <div class="alert__icon d-flex align-items-center text--primary"><i class="fas fa-spinner"></i></div>
                <p class="alert__message">
                    <span class="fw-bold"><?php echo app('translator')->get('Withdrawal Pending'); ?></span><br>
                    <small><i><?php echo app('translator')->get('Total'); ?> <?php echo e(showAmount($pendingWithdrawals)); ?> <?php echo e($general->cur_text); ?>

                            <?php echo app('translator')->get('withdrawal request is pending. Please wait for admin approval. The amount will send to the account which you\'ve provided. See'); ?> <a href="<?php echo e(route('user.withdraw.history')); ?>"
                                class="link-color"><?php echo app('translator')->get('withdrawal history'); ?></a></i></small>
                </p>
            </div>
        <?php endif; ?>

        <?php if($pendingDeposits): ?>
            <div class="alert border border--primary" role="alert">
                <div class="alert__icon d-flex align-items-center text--primary"><i class="fas fa-spinner"></i></div>
                <p class="alert__message">
                    <span class="fw-bold"><?php echo app('translator')->get('Deposit Pending'); ?></span><br>
                    <small><i><?php echo app('translator')->get('Total'); ?> <?php echo e(showAmount($pendingDeposits)); ?> <?php echo e($general->cur_text); ?>

                            <?php echo app('translator')->get('deposit request is pending. Please wait for admin approval. See'); ?> <a href="<?php echo e(route('user.deposit.history')); ?>"
                                class="link-color"><?php echo app('translator')->get('deposit history'); ?></a></i></small>
                </p>
            </div>
        <?php endif; ?>

        <?php if(!$user->ts): ?>
            <div class="alert border border--warning" role="alert">
                <div class="alert__icon d-flex align-items-center text--warning"><i class="fas fa-user-lock"></i></div>
                <p class="alert__message">
                    <span class="fw-bold"><?php echo app('translator')->get('2FA Authentication'); ?></span><br>
                    <small><i><?php echo app('translator')->get('To keep safe your account, Please enable'); ?> <a href="<?php echo e(route('user.twofactor')); ?>"
                                class="link-color"><?php echo app('translator')->get('2FA'); ?></a> <?php echo app('translator')->get('security'); ?>.</i> <?php echo app('translator')->get('It will make secure your account and balance.'); ?></small>
                </p>
            </div>
        <?php endif; ?>

        <?php if($user->kv == 0): ?>
            <div class="alert border border--info" role="alert">
                <div class="alert__icon d-flex align-items-center text--info"><i class="fas fa-file-signature"></i></div>
                <p class="alert__message">
                    <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Required'); ?></span><br>
                    <small><i><?php echo app('translator')->get('Please submit the required KYC information to verify yourself. Otherwise, you couldn\'t make any withdrawal requests to the system.'); ?> <a href="<?php echo e(route('user.kyc.form')); ?>"
                                class="link-color"><?php echo app('translator')->get('Click here'); ?></a> <?php echo app('translator')->get('to submit KYC information'); ?>.</i></small>
                </p>
            </div>
        <?php elseif($user->kv == 2): ?>
            <div class="alert border border--warning" role="alert">
                <div class="alert__icon d-flex align-items-center text--warning"><i class="fas fa-user-check"></i></div>
                <p class="alert__message">
                    <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Pending'); ?></span><br>
                    <small><i><?php echo app('translator')->get('Your submitted KYC information is pending for admin approval. Please wait till that.'); ?> <a href="<?php echo e(route('user.kyc.data')); ?>"
                                class="link-color"><?php echo app('translator')->get('Click here'); ?></a> <?php echo app('translator')->get('to see your submitted information'); ?></i></small>
                </p>
            </div>
        <?php endif; ?>

        <div class="row g-3 mt-4">
            <div class="col-lg-4">
                <div class="dashboard-widget">
                    <div class="d-flex justify-content-between">
                        <h5 class="text-secondary"><?php echo app('translator')->get('Successful Deposits'); ?></h5>
                    </div>
                    <h3 class="text--secondary my-4"><?php echo e(showAmount($successfulDeposits)); ?> <?php echo e($general->cur_text); ?></h3>
                    <div class="widget-lists">
                        <div class="row">
                            <div class="col-4">
                                <p class="fw-bold"><?php echo app('translator')->get('Submitted'); ?></p>
                                <small><?php echo e($general->cur_sym); ?><?php echo e(showAmount($submittedDeposits)); ?></small>
                            </div>
                            <div class="col-4">
                                <p class="fw-bold"><?php echo app('translator')->get('Pending'); ?></p>
                                <small><?php echo e($general->cur_sym); ?><?php echo e(showAmount($pendingDeposits)); ?></small>
                            </div>
                            <div class="col-4">
                                <p class="fw-bold"><?php echo app('translator')->get('Rejected'); ?></p>
                                <small><?php echo e($general->cur_sym); ?><?php echo e(showAmount($rejectedDeposits)); ?></small>
                            </div>
                        </div>
                        <hr>
                        <p><small><i><?php echo app('translator')->get('You\'ve requested to deposit'); ?> <?php echo e($general->cur_sym); ?><?php echo e(showAmount($requestedDeposits)); ?>.
                                    <?php echo app('translator')->get('Where'); ?> <?php echo e($general->cur_sym); ?><?php echo e(showAmount($initiatedDeposits)); ?>

                                    <?php echo app('translator')->get('is just initiated but not submitted.'); ?></i></small></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="dashboard-widget">
                    <div class="d-flex justify-content-between">
                        <h5 class="text-secondary"><?php echo app('translator')->get('Successful Withdrawals'); ?></h5>
                    </div>
                    <h3 class="text--secondary my-4"><?php echo e(showAmount($successfulWithdrawals)); ?> <?php echo e($general->cur_text); ?>

                    </h3>
                    <div class="widget-lists">
                        <div class="row">
                            <div class="col-4">
                                <p class="fw-bold"><?php echo app('translator')->get('Submitted'); ?></p>
                                <small><?php echo e($general->cur_sym); ?><?php echo e(showAmount($submittedWithdrawals)); ?></small>
                            </div>
                            <div class="col-4">
                                <p class="fw-bold"><?php echo app('translator')->get('Pending'); ?></p>
                                <small><?php echo e($general->cur_sym); ?><?php echo e(showAmount($pendingWithdrawals)); ?></small>
                            </div>
                            <div class="col-4">
                                <p class="fw-bold"><?php echo app('translator')->get('Rejected'); ?></p>
                                <small><?php echo e($general->cur_sym); ?><?php echo e(showAmount($rejectedWithdrawals)); ?></small>
                            </div>
                        </div>
                        <hr>
                        <p><small><i><?php echo app('translator')->get('You\'ve requested to withdraw'); ?> <?php echo e($general->cur_sym); ?><?php echo e(showAmount($requestedWithdrawals)); ?>.
                                    <?php echo app('translator')->get('Where'); ?> <?php echo e($general->cur_sym); ?><?php echo e(showAmount($initiatedWithdrawals)); ?>

                                    <?php echo app('translator')->get('is just initiated but not submitted.'); ?></i></small></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="dashboard-widget">
                    <div class="d-flex justify-content-between">
                        <h5 class="text-secondary"><?php echo app('translator')->get('Total Loan'); ?></h5>
                    </div>
                    <h3 class="text--secondary my-4"><?php echo e(showAmount($totalLoan)); ?> <?php echo e($general->cur_text); ?></h3>
                    <div class="widget-lists">
                        <div class="row">
                            <div class="col-3">
                                <p class="fw-bold"><?php echo app('translator')->get('Pending'); ?></p>
                                <small><?php echo e($general->cur_sym); ?><?php echo e(showAmount($pendingLoans)); ?></small>
                            </div>
                            <div class="col-3">
                                <p class="fw-bold"><?php echo app('translator')->get('Running'); ?></p>
                                <small><?php echo e($general->cur_sym); ?><?php echo e(showAmount($runningLoans)); ?></small>
                            </div>

                            <div class="col-3">
                                <p class="fw-bold"><?php echo app('translator')->get('Completed'); ?></p>
                                <small><?php echo e($general->cur_sym); ?><?php echo e(showAmount($paidLoans)); ?></small>
                            </div>
                            <div class="col-3">
                                <p class="fw-bold"><?php echo app('translator')->get('Rejected'); ?></p>
                                <small><?php echo e($general->cur_sym); ?><?php echo e(showAmount($rejectedLoans)); ?></small>
                            </div>
                        </div>

                        <hr>
                        <p><small><i><?php echo app('translator')->get('You\'ve'); ?> <?php echo e(getAmount($totalLoans)); ?> <?php echo app('translator')->get('Loans'); ?>.
                                    <?php echo app('translator')->get('Which is'); ?> <?php echo e(getAmount($totalRunningLoans)); ?> <?php echo app('translator')->get('Running'); ?> &
                                    <?php echo e(getAmount($totalPendingLoans)); ?>

                                    <?php echo app('translator')->get('is Pending'); ?> & <?php echo e(getAmount($totalRejectedLoans)); ?> <?php echo app('translator')->get('is Rejected'); ?> &
                                    <?php echo e(getAmount($totalPaidLoans)); ?> <?php echo app('translator')->get('is Completed'); ?></i></small>.</p>
                    </div>
                </div>
            </div>
        </div>

        <h3 class="my-4"> <?php echo app('translator')->get('My Running Loans'); ?></h3>
        <div class="card custom--card ">
            <div class="table-responsive">
                <table class="table table--responsive--md">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Loan Number'); ?></th>
                            <th><?php echo app('translator')->get('Plan Name'); ?></th>
                            <th><?php echo app('translator')->get('Loan Amount'); ?></th>
                            <th><?php echo app('translator')->get('Installment'); ?></th>
                            <th><?php echo app('translator')->get('Installment Amount'); ?></th>
                            <th><?php echo app('translator')->get('Next Installment'); ?></th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__empty_1 = true; $__currentLoopData = $userRunningLoans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <span class="text--primary"> <?php echo e(__($loan->loan_number)); ?></span>
                                </td>
                                <td>
                                    <?php echo e(__($loan->plan->name)); ?>

                                </td>
                                <td>
                                    <p>
                                        <b><?php echo e(showAmount($loan->amount)); ?> <?php echo e($general->cur_text); ?></b><br>
                                        <small class="text--base">
                                            <?php echo e($general->cur_sym . showAmount($loan->payable_amount)); ?>

                                            <small>(<?php echo app('translator')->get('Need to pay'); ?>)</small>
                                        </small>
                                    </p>
                                </td>
                                <td>
                                    <span> <?php echo app('translator')->get('Total'); ?> : <?php echo e(__($loan->total_installment)); ?></span>
                                    <br>
                                    <small class="text--base">
                                        <?php echo app('translator')->get('Given'); ?> : <?php echo e(__($loan->given_installment)); ?>

                                    </small>
                                </td>
                                <td>
                                    <span><?php echo e($general->cur_sym . showAmount($loan->per_installment)); ?></span>
                                    <br>
                                    <small class="text--base">
                                        <?php echo app('translator')->get('In Every'); ?> <?php echo e(__($loan->installment_interval)); ?>

                                        <?php echo app('translator')->get('Days'); ?>
                                    </small>
                                </td>
                                <td>
                                    <?php if($loan->nextInstallment): ?>
                                        <b> <?php echo e(showDateTime($loan->nextInstallment->installment_date, 'd M, Y')); ?></b>
                                    <?php endif; ?>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>

                    </tbody>
                </table>
            </div>
        </div>
        <?php if($totalRunningLoans > 5): ?>
            <span class="d-flex justify-content-center">
                <a href="<?php echo e(route('user.loan.list')); ?>?status=<?php echo e(Status::LOAN_RUNNING); ?>" class="btn btn--base my-2">
                    <?php echo app('translator')->get('See All'); ?></a>
            </span>
        <?php endif; ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ultimatx/public_html/eleonagroupintl.com/core/resources/views/templates/basic/user/dashboard.blade.php ENDPATH**/ ?>