<?php
    $language = App\Models\Language::all();
    $contactContent = getContent('contact.content', true);
?>

<section class="top-header">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <ul class="list list--row d-flex align-items-center">
                    <li class="list--row__item">
                        <ul class="list vf-info-list">
                            <li class="vf-info-list__item">
                                <div class="d-flex">
                                    <div class="flex-shrink-0">
                                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/icon-envelop.png')); ?>">
                                    </div>
                                    <div class="ms-3">
                                        <p class="label mb-0 fw-bold text-uppercase t-text-white">
                                            <?php echo app('translator')->get('Email'); ?>
                                        </p>

                                        <a href="mailto:<?php echo e($contactContent->data_values->email); ?>" class="mb-0 vf-info-list__text"><?php echo e(__($contactContent->data_values->email)); ?></a>
                                    </div>

                                </div>
                            </li>
                            <li class="vf-info-list__item">
                                <div class="d-flex">
                                    <div class="flex-shrink-0">
                                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/icon-location.png')); ?>">
                                    </div>
                                    <div class="ms-3">
                                        <p class="label mb-0 fw-bold text-uppercase t-text-white">
                                            <?php echo app('translator')->get('Address'); ?>
                                        </p>
                                        <p class="mb-0 vf-info-list__text">
                                            <?php echo e(__($contactContent->data_values->location)); ?>

                                        </p>
                                    </div>
                                </div>
                            </li>
                            <li class="vf-info-list__item">
                                <div class="d-flex">
                                    <div class="flex-shrink-0">
                                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/icon-phone.png')); ?>">
                                    </div>
                                    <div class="ms-3">
                                        <p class="label mb-0 fw-bold text-uppercase t-text-white">
                                            <?php echo app('translator')->get('Phone'); ?>
                                        </p>
                                        <a href="tel:<?php echo e($contactContent->data_values->phone); ?>" class="mb-0 fw-md vf-info-list__text">
                                            <?php echo e($contactContent->data_values->phone); ?></a>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </li>

                    <?php if($general->multi_language): ?>
                        <li class="ms-auto">
                            <div class="custom--nice-select">
                                <div class="language-select">
                                    <select class="select langSel">
                                        <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->code); ?>" <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>><?php echo e(__($item->name)); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</section>

<header class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a href="<?php echo e(route('home')); ?>" class="logo">
                <img src="<?php echo e(getImage('assets/images/logoIcon/logo.png')); ?>" alt="viserhyip" class="img-fluid logo__is" />
            </a>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu align-items-lg-center">
                    <?php if($general->multi_language): ?>
                        <li class="nav-item mb-2 d-block d-lg-none">
                            <div class="top-button d-flex flex-wrap justify-content-between align-items-center">
                                <div class="custom--nice-select">
                                    <div class="language-box">
                                        <select class="select langSel">
                                            <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->code); ?>" <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>>
                                                    <?php echo e(__($item->name)); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(menuActive('home')); ?>" aria-current="page" href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                    </li>
                    <?php if(@$pages): ?>
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item">
                                <a class="<?php echo e(menuActive('pages', [$data->slug])); ?> nav-link" href="<?php echo e(route('pages', [$data->slug])); ?>"><?php echo e(__($data->name)); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(menuActive('loan')); ?>" href="<?php echo e(route('loan')); ?>"><?php echo app('translator')->get('Plans'); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(menuActive('blog')); ?>" href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blogs'); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(menuActive('contact')); ?>" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                    </li>
                    <?php if(auth()->guard()->check()): ?>
                        <li class="nav-item mt-2 d-block d-lg-none">
                            <div class="account mt-1">
                                <a href="<?php echo e(route('user.home')); ?>" class="btn btn--md btn--base fw-bold w-100">
                                    <?php echo app('translator')->get('Dashboard'); ?>
                                </a>
                            </div>
                        </li>
                    <?php else: ?>
                        <li class="nav-item mt-2 d-block d-lg-none">
                            <div class="account mt-1">
                                <a href="<?php echo e(route('user.login')); ?>" class="btn btn--md btn--base fw-bold w-100">
                                    <?php echo app('translator')->get('Join Now'); ?>
                                </a>
                            </div>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>

            <?php if(auth()->guard()->check()): ?>
                <div class="account d-none d-lg-block">
                    <a href="<?php echo e(route('user.home')); ?>" class="btn btn--md btn--base fw-bold w-100">
                        <?php echo app('translator')->get('Dashboard'); ?>
                    </a>
                </div>
            <?php else: ?>
                <div class="account d-none d-lg-block">
                    <a href="<?php echo e(route('user.login')); ?>" class="btn btn--md btn--base fw-bold w-100">
                        <?php echo app('translator')->get('Login'); ?>
                    </a>
                </div>
            <?php endif; ?>
        </nav>
    </div>
</header>
<?php /**PATH /home/ultimatx/public_html/eleonagroupintl.com/core/resources/views/templates/basic/partials/header.blade.php ENDPATH**/ ?>