<?php
    $loginContent = getContent('login.content', true);
?>

<?php $__env->startSection('content'); ?>
    <div class="section container">
        <div class="row g-lg-0">
            <div class="col-lg-6 d-none d-lg-block">
                <div class="h-100 auth-form__bg" style="background-image: url(<?php echo e(getImage('assets/images/frontend/login/' . @$loginContent->data_values->image, '800x1100')); ?>);">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="auth-form__content section">
                    <h3 class="text-capitalize text-center mt-0 mb-4">
                        <?php echo e(__($loginContent->data_values->heading)); ?>

                    </h3>
                    <form method="POST" action="<?php echo e(route('user.login')); ?>" class="row g-4">
                        <?php echo csrf_field(); ?>
                        <div class="col-12">
                            <div class="auth-form__input-group">
                                <span class="auth-form__input-icon">
                                    <i class="la la-user"></i>
                                </span>
                                <input type="text" name="username" class="auth-form__input" value="<?php echo e(old('username')); ?>" placeholder="<?php echo app('translator')->get('Username or Email'); ?>" required />
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="auth-form__input-group">
                                <span class="auth-form__input-icon">
                                    <i class="la la-lock"></i>
                                </span>
                                <input type="password" name="password" class="auth-form__input" placeholder="<?php echo app('translator')->get('Your password'); ?>" required />
                                <span class="auth-form__input-icon auth-form__toggle-pass">
                                    <i class="bx bxs-hide"></i>
                                </span>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="d-flex flex-wrap justify-content-between my-4">
                                <div class="form-group form-check">
                                    <input class="form-check-input" type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="remember">
                                        <?php echo app('translator')->get('Remember Me'); ?>
                                    </label>
                                </div>
                                <a class="forgot-pass text-decoration-none" href="<?php echo e(route('user.password.request')); ?>">
                                    <?php echo app('translator')->get('Forgot password?'); ?>
                                </a>
                            </div>
                        </div>

                        

                        <div class="col-12">
                            <button type="submit" class="btn btn--base btn--xxl w-100 text-capitalize xl-text">
                                <?php echo app('translator')->get('Login'); ?>
                            </button>
                        </div>

                        <div class="col-12">
                            <p class="mb-0 text-capitalize text-center">
                                <?php echo app('translator')->get('Already have an account yet'); ?>?
                                <a href="<?php echo e(route('user.register')); ?>" class="text-decoration-none">
                                    <?php echo app('translator')->get('Register Now'); ?>
                                </a>
                            </p>
                        </div>

                        <?php
                            $credentials = $general->socialite_credentials;
                        ?>
                        <?php if($credentials->google->status == Status::ENABLE || $credentials->facebook->status == Status::ENABLE || $credentials->linkedin->status == Status::ENABLE): ?>
                            <div class="col-12">
                                <div class="auth-form__divider">
                                    <span class="d-block text-center text-capitalize auth-form__divider-text">
                                        <?php echo app('translator')->get(' or'); ?>
                                    </span>
                                </div>
                            </div>
                            <div class="col-12">
                                <p class="mb-0 text-capitalize text-center">
                                    <?php echo app('translator')->get('Continue with social media'); ?>
                                </p>
                            </div>

                            <div class="col-12">
                                <ul class="list list--row justify-content-center">
                                    <?php if($credentials->facebook->status == Status::ENABLE): ?>
                                        <li class="list--row__item">
                                            <a href="<?php echo e(route('user.social.login', 'facebook')); ?>" class="t-link icon icon--circle icon--md bg--primary t-text-white t-link--light">
                                                <i class="bx bxl-facebook"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($credentials->google->status == Status::ENABLE): ?>
                                        <li class="list--row__item">
                                            <a href="<?php echo e(route('user.social.login', 'google')); ?>" class="t-link icon icon--circle icon--md bg--danger t-text-white t-link--light">
                                                <i class="bx bxl-google"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($credentials->linkedin->status == Status::ENABLE): ?>
                                        <li class="list--row__item">
                                            <a href="<?php echo e(route('user.social.login', 'linkedin')); ?>" class="t-link icon icon--circle icon--md bg--info t-text-white t-link--light">
                                                <i class="bx bxl-linkedin"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ultimatx/public_html/eleonagroupintl.com/core/resources/views/templates/basic/user/auth/login.blade.php ENDPATH**/ ?>