<div class="row g-4">
    <div class="col-lg-12">
        <ul class="nav nav-pills custom--tab" id="pills-tab" role="tablist">
            <?php $__currentLoopData = @$categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="nav-item" role="presentation">
                    <button class="nav-link <?php if($loop->first): ?> active <?php endif; ?>"
                        id="pills-<?php echo e(slug($category->name)); ?>-tab" data-bs-toggle="pill"
                        data-bs-target="#pills-<?php echo e(slug($category->name)); ?>" type="button" role="tab"
                        aria-controls="pills-<?php echo e(slug($category->name)); ?>"
                        aria-selected="false"><?php echo e(__($category->name)); ?>

                    </button>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <div class="tab-content" id="pills-tabContent">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="tab-pane fade <?php if($loop->first): ?> show active <?php endif; ?>"
                    id="pills-<?php echo e(slug($category->name)); ?>" role="tabpanel"
                    aria-labelledby="pills-<?php echo e(slug($category->name)); ?>-tab" tabindex="0">

                    <div class="row justify-content-center gy-4 gx-sm-2 gx-md-4">
                        <?php $__empty_1 = true; $__currentLoopData = $category->plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="col-lg-4 col-sm-6 col-10">
                                <div class="plan-card rounded-3 h-100 d-flex flex-column justify-content-between">
                                    <div class="plan-card-header-body">
                                        <div class="plan-card__header">
                                            <div class="plan-name-tag">
                                                <h4 class="plan-name"><?php echo e(__($plan->name)); ?></h4>
                                                <span class="plan-tagline"><?php echo e(__($plan->title)); ?></span>
                                            </div>
                                            <div class="plan-price">
                                                <h4 class="title"><?php echo e(getAmount($plan->loanInterest())); ?>%</h4>
                                                <span><?php echo app('translator')->get('Interest Rate'); ?></span>
                                            </div>
                                        </div>

                                        <div class="plan-card__body text-center">
                                            <ul class="plan-feature-list">
                                                <li class="plan-feature-list-item">
                                                    <span class="plan-feature-list-title"><?php echo app('translator')->get('Take Minimum'); ?></span>
                                                    <span
                                                        class="plan-feature-list-amount "><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($plan->minimum_amount)); ?></span>
                                                </li>
                                                <li class="plan-feature-list-item">
                                                    <span class="plan-feature-list-title"><?php echo app('translator')->get('Take Maximum'); ?></span>
                                                    <span
                                                        class="plan-feature-list-amount "><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($plan->maximum_amount)); ?></span>
                                                </li>
                                                <li class="plan-feature-list-item">
                                                    <span class="plan-feature-list-title"><?php echo app('translator')->get('Per Installment'); ?></span>
                                                    <span
                                                        class="plan-feature-list-amount"><?php echo e(getAmount($plan->per_installment)); ?>%</span>
                                                </li>
                                                <li class="plan-feature-list-item">
                                                    <span class="plan-feature-list-title"><?php echo app('translator')->get('Installment Interval'); ?></span>
                                                    <span class="plan-feature-list-amount">
                                                        <?php echo e($plan->installment_interval); ?>

                                                        <?php echo app('translator')->get('Days'); ?></span>
                                                </li>
                                                <li class="plan-feature-list-item">
                                                    <span class="plan-feature-list-title"> <?php echo app('translator')->get('Total Installment'); ?></span>
                                                    <span
                                                        class="plan-feature-list-amount"><?php echo e($plan->total_installment); ?></span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="plan-card__footer text-center">
                                        <button type="button" data-id="<?php echo e($plan->id); ?>"
                                            data-planname="<?php echo e(__($plan->name)); ?>"
                                            data-minimum="<?php echo e($general->cur_sym); ?><?php echo e(showAmount($plan->minimum_amount)); ?>"
                                            data-maximum="<?php echo e($general->cur_sym); ?><?php echo e(showAmount($plan->maximum_amount)); ?>"
                                            class="btn btn-md btn--xl xl-text w-100 btn--base loanBtn"><?php echo app('translator')->get('Apply Now'); ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<?php $__env->startPush('modal'); ?>
    <div class="modal fade" id="loanModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="" method="post">
                    <?php if(auth()->guard()->check()): ?>
                        <div class="modal-header">
                            <h5 class="modal-title method-name" id="exampleModalLabel"><?php echo app('translator')->get('Apply for '); ?> <span
                                    class="loan-name"></span> </h5>
                            <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <i class="las la-times"></i>
                            </span>
                        </div>
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="form-group">
                                <label><?php echo app('translator')->get('Amount'); ?></label>
                                <div class="input-group">
                                    <input type="number" step="any" name="amount" class="form-control form--control"
                                        placeholder="<?php echo app('translator')->get('Enter An Amount'); ?>" required>
                                    <span class="input-group-text"> <?php echo e(__($general->cur_text)); ?> </span>
                                </div>
                                <p class="mt-2"><small class="text--danger min-limit d-block"></small>
                                    <small class="text--danger max-limit"></small>
                                </p>
                            </div>
                            <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Confirm'); ?></button>
                        </div>
                    <?php else: ?>
                        <div class="modal-body">
                            <div class="text-center"><i class="la la-times-circle text--danger la-6x" aria-hidden="true"></i>
                            </div>
                            <h3 class="text-center mt-3"><?php echo app('translator')->get('You are not logged in!'); ?></h3>
                        </div>

                        <div class="modal-footer">
                            <a href="<?php echo e(route('user.login')); ?>" class="btn btn-sm btn--base"><?php echo app('translator')->get('Login'); ?></a>
                            <button type="button" class="btn btn-sm btn--dark" data-bs-dismiss="modal"
                                aria-label="Close"><?php echo app('translator')->get('Close'); ?></button>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.loanBtn').on('click', (e) => {
                var modal = $('#loanModal');
                let data = e.currentTarget.dataset;
                modal.find('.min-limit').text(`Minimum Amount ${data.minimum}`);
                modal.find('.max-limit').text(`Maximum Amount ${data.maximum}`);
                modal.find('.loan-name').text(`${data.planname}`);
                let form = modal.find('form')[0];
                form.action = `<?php echo e(route('user.loan.apply', '')); ?>/${data.id}`;
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/ultimatx/public_html/eleonagroupintl.com/core/resources/views/templates/basic/partials/loan_plans.blade.php ENDPATH**/ ?>