<?php
$pageName  = "Transaction Status";
include($_SERVER['DOCUMENT_ROOT'] . "/user/layout/header.php");

if (!isset($_SESSION['is_transfer'])) {
    header("Location:./dashboard.php");
}

if (!isset($_SESSION['dom_transfer'])) {
    header("Location:./dashboard.php");
}

unset($_SESSION['is_dom_transfer']);
unset($_SESSION['is_wire_transfer']);

$user_id = userDetails('id');

// ✅ Fetch acct_status from users table
$userQuery = $conn->prepare("SELECT acct_status FROM users WHERE id = :user_id LIMIT 1");
$userQuery->execute(['user_id' => $user_id]);
$userInfo = $userQuery->fetch(PDO::FETCH_ASSOC);
$acct_status = $userInfo['acct_status'];

// ✅ Fetch latest transaction
$sql = "SELECT * FROM transactions WHERE user_id = :user_id ORDER BY trans_id DESC LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->execute(['user_id' => $user_id]);
$result = $stmt->fetch(PDO::FETCH_ASSOC);
$transStatus = TranStatus($result);

// ✅ Fetch from temp_trans
$sq3 = "SELECT * FROM temp_trans WHERE user_id = :user_id ORDER BY trans_id DESC LIMIT 1";
$stmt = $conn->prepare($sq3);
$stmt->execute(['user_id' => $user_id]);
$resultss = $stmt->fetch(PDO::FETCH_ASSOC);

$amount = $resultss['amount'];
$transactiontype = $resultss['trans_type'];
$WireFee = $page['wirefee'];
$DomesticFee = $page['domesticfee'];
?>

<div class="content-body">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="page-title">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-xl-4">
                            <div class="page-title-content">
                                <h3>
                                    <?php if ($acct_status != 'active'): ?>
                                        Transaction Pending...
                                    <?php else: ?>
                                        Transaction Successful...
                                    <?php endif; ?>
                                </h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-12 col-xl-12">
                <div class="row">
                    <div class="col-xl-6 col-lg-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <?php if ($acct_status != 'active'): ?>
                                        <p>Dear <strong><?= $fullName ?></strong>, Your transaction is currently <strong>pending</strong>. 
                                        It will be processed shortly. Please wait while we finalize the transfer. <br><br> For inquiries, 
                                        contact <strong><?= $page['url_tel']?></strong> or email: 
                                        <strong><?= $page['url_email']?></strong>.</p>
                                    <?php else: ?>
                                        <p>Dear <strong><?= $fullName ?></strong>, Your transaction has been successful. 
                                        Kindly note this transaction may not reflect immediately in your account until it is cleared! 
                                        <br><br> For further inquiries, contact <strong><?= $page['url_tel']?></strong> or email: 
                                        <strong><?= $page['url_email']?></strong>.</p>
                                    <?php endif; ?>

                                    <table class="table table-bordered">
                                        <tbody>
                                            <?php if ($transactiontype == 'Domestic transfer'): ?>
                                                <tr><td>Trans Type</td><td><?= $result['trans_type'] ?></td></tr>
                                                <tr><td>Sender Name</td><td><?= $resultss['account_name'] ?></td></tr>
                                                <tr><td>Reciever Name</td><td><?= $resultss['reciever_name'] ?></td></tr>
                                                <tr><td>Reciever Address</td><td><?= $resultss['bank_address'] ?></td></tr>
                                                <tr><td>Bank Name</td><td><?= $result['bank_name'] ?></td></tr>
                                                <tr><td>Account Number</td><td><?= $result['account_number'] ?></td></tr>
                                                <tr><td>Amount</td><td><?= $currency ?><?= number_format($amount, 2, '.', ','); ?></td></tr>
                                                <tr><td>Account Type</td><td><?= $result['account_type'] ?></td></tr>
                                                <tr><td>Bank Country</td><td><?= $result['bank_country'] ?></td></tr>
                                                <tr><td>Fee</td><td><?= $currency ?><?= number_format($DomesticFee, 2, '.', ','); ?></td></tr>
                                                <tr><td>Refrence ID</td><td>#<?= $result['refrence_id'] ?></td></tr>
                                                <tr><td>Date</td><td><?= $result['created_at'] ?></td></tr>
                                                <tr><td>STATUS</td><td><?= $result['trans_status'] ?></td></tr>
                                            <?php elseif ($transactiontype == 'Wire transfer'): ?>
                                                <tr><td>Trans Type</td><td><?= $result['trans_type'] ?></td></tr>
                                                <tr><td>Beneficiary Name</td><td><?= $result['account_name'] ?></td></tr>
                                                <tr><td>Beneficiary Bank Name</td><td><?= $result['bank_name'] ?></td></tr>
                                                <tr><td>Account Number</td><td><?= $result['account_number'] ?></td></tr>
                                                <tr><td>Amount</td><td><?= $currency ?><?= number_format($amount, 2, '.', ','); ?></td></tr>
                                                <tr><td>Routine Number</td><td><?= $result['routine_number'] ?></td></tr>
                                                <tr><td>Account Type</td><td><?= $result['account_type'] ?></td></tr>
                                                <tr><td>Swift Code</td><td><?= $result['swift_code'] ?></td></tr>
                                                <tr><td>Bank Country</td><td><?= $result['bank_country'] ?></td></tr>
                                                <tr><td>Fee</td><td><?= $currency ?><?= number_format($WireFee, 2, '.', ','); ?></td></tr>
                                                <tr><td>Refrence ID</td><td>#<?= $result['refrence_id'] ?></td></tr>
                                                <tr><td>Date</td><td><?= $result['created_at'] ?></td></tr>
                                                <tr><td>STATUS</td><td><?= $result['trans_status'] ?></td></tr>
                                            <?php else: ?>
                                                <tr><td>Trans Type</td><td><?= $result['trans_type'] ?></td></tr>
                                                <tr><td>Amount</td><td><?= $currency ?><?= number_format($amount, 2, '.', ','); ?></td></tr>
                                                <tr><td>Refrence ID</td><td>#<?= $result['refrence_id'] ?></td></tr>
                                                <tr><td>Date</td><td><?= $result['created_at'] ?></td></tr>
                                                <tr><td>STATUS</td><td><?= $result['trans_status'] ?></td></tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>

                                    <br><br>
                                    <div class="progress">
                                        <div class="progress-bar progress-bar-success progress-bar-striped" role="progressbar"
                                            aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width:100%">
                                            Transaction 100% <?= ($acct_status != 'active') ? 'received, pending final processing' : 'successful' ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Transactions -->
                    <div class="col-xl-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Recent Transaction</h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="table-responsive">
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th>Transaction Type</th>
                                                    <th>Amount</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $sql2 = "SELECT * FROM transactions WHERE user_id = :user_id ORDER BY trans_id DESC LIMIT 6";
                                                $wire = $conn->prepare($sql2);
                                                $wire->execute(['user_id' => $user_id]);

                                                while ($row = $wire->fetch(PDO::FETCH_ASSOC)) {
                                                    $amount = $row['amount'];
                                                ?>
                                                    <tr>
                                                        <td><?= $row['trans_type'] ?></td>
                                                        <td><?= $currency ?><?= number_format($amount, 2, '.', ','); ?></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End Recent Transactions -->

                </div>
            </div>
        </div>
    </div>
</div>

<?php include(__DIR__."/../user/layout/footer.php"); ?>
