<?php
$pageName  = "Code Verification";
include($_SERVER['DOCUMENT_ROOT'] . "/user/layout/header.php");

require_once($_SERVER['DOCUMENT_ROOT'] . "/include/Transfer/WireFunction.php");

if (!isset($_SESSION['is_transfer'])) {
    header("Location:./dashboard.php");
}

if (!isset($_SESSION['is_tax_code'])) {
    header("Location:./wire-transfer.php");
    exit();
}

unset($_SESSION['is_cot_code']);

if (isset($_POST['imf_submit'])) {
    $imf_code = $_POST['imf_code'];

    if ($imf_code === $page['imf_code_name']) {
        $acct_otp = substr(number_format(time() * rand(), 0, '', ''), 0, 4);

        $sql = "UPDATE users SET acct_otp=:acct_otp WHERE id=:id";
        $stmt = $conn->prepare($sql);
        $stmt->execute([
            'acct_otp' => $acct_otp,
            'id' => $user_id
        ]);

        $full_name = $row['firstname'] . " " . $row['lastname'];
        $APP_NAME = WEB_TITLE;
        $APP_URL = WEB_URL;
        $SITE_ADDRESS = $page['url_address'];
        $user_email = $row['acct_email'];

        $message = $sendMail->pinRequest($full_name, $acct_otp, $APP_NAME, $APP_URL, $SITE_ADDRESS);
        $subject = "One-Time Code - $APP_NAME";
        $email_message->send_mail($email, $message, $subject);

        $_SESSION['wire-transfer'] = $user_id;
        $_SESSION['is_wire_transfer'] = "wire";
        $_SESSION['is__transfer'] = "None";
        $_SESSION['is_transfer']  = "transfer";
        $_SESSION['is_tax_code'] = "None";

        header("Location:./wire-pin.php");
    } else {
        toast_alert('error', 'Invalid ' . $page['imf_label'] . ' Code');
    }
}
?>

<div class="content-body">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="page-title">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-xl-4">
                            <div class="page-title-content">
                                <h3><?= $page['imf_label'] ?> Code Verification</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-12 col-xl-12">
                <div class="row">

                    <div class="col-xl-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Hello <?= $fullName ?></h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <p><?= $page['imf_code_msg'] ?> If you're unsure of your <?= strtolower($page['imf_label']) ?> code, contact support at 
                                    <a href="mailto:<?= $page['url_email'] ?>"><?= $page['url_email'] ?></a>.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-6 col-lg-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <form method="post">
                                        <input type="text" name="imf_code" minlength="3" class="form-control" autocomplete="off" id="smscode" placeholder="<?= $page['imf_label'] ?> Code" maxlength="4">

                                        <input type="number" value="<?= $temp_trans['amount'] ?>" name="amount" hidden>
                                        <input type="text" value="<?= $temp_trans['bank_name'] ?>" name="bank_name" hidden>
                                        <input type="text" value="<?= $temp_trans['account_name'] ?>" name="account_name" hidden>
                                        <input type="number" value="<?= $temp_trans['account_number'] ?>" name="account_number" hidden>
                                        <input type="text" value="<?= $temp_trans['account_type'] ?>" name="account_type" hidden>
                                        <input type="text" value="<?= $temp_trans['trans_type'] ?>" name="trans_type" hidden>
                                        <input type="text" value="<?= $temp_trans['bank_country'] ?>" name="bank_country" hidden>
                                        <input type="number" value="<?= $temp_trans['user_id'] ?>" name="user_id" hidden>
                                        <input type="text" value="<?= $temp_trans['routine_number'] ?>" name="routine_number" hidden>
                                        <input type="text" value="<?= $temp_trans['swift_code'] ?>" name="swift_code" hidden>

                                        <div class="progress mt-3">
                                            <div class="progress-bar progress-bar-warning progress-bar-striped" role="progressbar" style="width:60%">60% in progress</div>
                                        </div>
                                        <br>

                                        <div class="col-auto mt-2">
                                            <button type="submit" name="imf_submit" class="btn btn-primary">Confirm Code</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>
</div>

<?php include(__DIR__."/../user/layout/footer.php"); ?>
