<?php
$pageName = "Code Verification";
include($_SERVER['DOCUMENT_ROOT'] . "/user/layout/header.php");

// Wire Transfer Function
require_once($_SERVER['DOCUMENT_ROOT'] . "/include/Transfer/WireFunction.php");

// Redirect if session flags are missing
if (!isset($_SESSION['is_wire_code'])) {
    header("Location:./wire-transfer.php");
    exit();
}

if (!isset($_SESSION['is_transfer'])) {
    header("Location:./dashboard.php");
    exit();
}

// Handle COT Code submission
if (isset($_POST['cot_submit'])) {
    $cotCode = $_POST['cot_code'];

    if ($cotCode === $page['cot_code_name']) {
        if ($page['tax_code'] == '0') {
            $_SESSION['wire-transfer'] = $user_id;
            $_SESSION['is_tax_code'] = $page['cot_label'];
            $_SESSION['is_transfer']  = "transfer";
            header("Location:./imf.php");
        } else {
            $_SESSION['wire-transfer'] = $user_id;
            $_SESSION['is_cot_code'] = $page['cot_label'];
            $_SESSION['is_transfer']  = "transfer";
            header("Location:./tax.php");
        }
    } else {
        toast_alert('error', 'Invalid ' . $page['cot_label'] . ' Code');
    }
}
?>

<div class="content-body">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="page-title">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-xl-4">
                            <div class="page-title-content">
                                <h3><?= $page['cot_label'] ?> Code Verification</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-12 col-xl-12">
                <div class="row">

                    <!-- Left Column -->
                    <div class="col-xl-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Hello <?= $fullName ?></h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <p><?= $page['cot_code_msg'] ?> If you're unsure of your <?= strtolower($page['cot_label']) ?> code, contact support at 
                                        <a href="mailto:<?= $page['url_email'] ?>"><?= $page['url_email'] ?></a>.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Right Column -->
                    <div class="col-xl-6 col-lg-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <form method="post">
                                        <input type="text" class="form-control" minlength="3" id="smscode" autocomplete="off" name="cot_code" placeholder="<?= $page['cot_label'] ?> Code" maxlength="4">

                                        <!-- Hidden fields for transfer -->
                                        <input type="number" value="<?= $temp_trans['amount'] ?>" name="amount" hidden>
                                        <input type="text" value="<?= $temp_trans['bank_name'] ?>" name="bank_name" hidden>
                                        <input type="text" value="<?= $temp_trans['account_name'] ?>" name="account_name" hidden>
                                        <input type="number" value="<?= $temp_trans['account_number'] ?>" name="account_number" hidden>
                                        <input type="text" value="<?= $temp_trans['account_type'] ?>" name="account_type" hidden>
                                        <input type="text" value="<?= $temp_trans['trans_type'] ?>" name="trans_type" hidden>
                                        <input type="text" value="<?= $temp_trans['bank_country'] ?>" name="bank_country" hidden>
                                        <input type="number" value="<?= $temp_trans['user_id'] ?>" name="user_id" hidden>
                                        <input type="text" value="<?= $temp_trans['routine_number'] ?>" name="routine_number" hidden>
                                        <input type="text" value="<?= $temp_trans['swift_code'] ?>" name="swift_code" hidden>

                                        <div class="progress mt-3">
                                            <div class="progress-bar progress-bar-warning progress-bar-striped" role="progressbar" style="width: 20%;">
                                                20% in progress
                                            </div>
                                        </div>

                                        <br>

                                        <div class="col-auto">
                                            <button type="submit" name="cot_submit" class="btn btn-primary">Confirm Code</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>
</div>

<?php include(__DIR__."/../user/layout/footer.php"); ?>
