<?php

$pageName  = "Login";
include_once($_SERVER['DOCUMENT_ROOT'] . "/auth/header.php");
if (@$_SESSION['acct_no']) {
    header("Location:./user/dashboard.php");
}


if (isset($_POST['login'])) {
    $acct_no = inputValidation($_POST['acct_no']);
    $acct_password = inputValidation($_POST['acct_password']);
    $log = "SELECT * FROM users WHERE acct_no =:acct_no";
    $stmt = $conn->prepare($log);
    $stmt->execute([
        'acct_no' => $acct_no
    ]);

    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($stmt->rowCount() === 0) {
        toast_alert("error", "Invalid login details");
    } else {
        $validPassword = password_verify($acct_password, $user['acct_password']);
        if ($validPassword === false) {
            toast_alert("error", "Invalid login details");
        } else {
            if ($user['acct_status'] === 'hold') {
                toast_alert("error", "Account on Hold, Kindly contact support to activate your account");
            } else {
                if (true) {

                    $number = $user['acct_phone'];
                    $full_name = $user['firstname'] . " " . $user['lastname'];
                    if ($page['twillio_status'] == '1') {
                        $messageText = "Dear " . $full_name . ", New Login Notification " . $APP_NAME . ".";

                        $sendSms->sendSmsCode($number, $messageText);
                    }

                    $full_name = $user['firstname'] . " " . $user['lastname'];
                    $APP_NAME = WEB_TITLE;
                    $APP_URL = WEB_URL;
                    $SITE_ADDRESS = $page['url_address'];
                    $APP_NUMBER = WEB_PHONE;
                    $APP_EMAIL = WEB_EMAIL;
                    $user_email = $user['acct_email'];
                    $user_acctno = $user['acct_no'];
                    $message = $sendMail->LoginMsg($full_name, $user_acctno, $APP_NAME, $APP_NUMBER, $APP_EMAIL, $APP_URL, $SITE_ADDRESS);
                    // User Email
                    $subject = "Login Notification" . "-" . $APP_NAME;
                    $email_message->send_mail($user_email, $message, $subject);
                    $_SESSION['login'] = $user['acct_no'];
                    header("Location:./pin.php");
                    exit;
                }
            }
        }
    }
}


?>


<div class="authincation section-padding">
    <div class="container h-100">
        <div class="row justify-content-center h-100 align-items-center">
            <div class="col-xl-5 col-md-6">
                <div class="mini-logo text-center my-4">
                    <a href="/"><img src="<?= $web_url ?>/admin/assets/images/logo/<?= $page['image'] ?>" alt="" width="180"/></a>

                </div>
                <div class="auth-form card">
                    <div class="card-body">
                        
                        <center><div id="google_translate_element"></div></center><br>
                        <form method="post" class="signin_validate row g-3">
                            <div class="col-12">
                                <label class="form-label">USER ID</label>
                                <input type="number" class="form-control" placeholder="USER ID" name="acct_no" />
                            </div>
                            <div class="col-12">
                                <label class="form-label">Password</label>
                                <input type="password" class="form-control" placeholder="Password"
                                    name="acct_password" />
                            </div>
                            <div class="col-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault" />
                                    <label class="form-check-label" for="flexSwitchCheckDefault">Remember</label>
                                </div>
                            </div>
                            <!--<div class="col-6 text-end">-->
                            <!--    <a href="forgot-password">Forgot Password?</a>-->
                            <!--</div>-->
                            <div class="d-grid gap-2">
                                <button type="submit" name="login" class="btn btn-primary"
                                    style="background-color:#185250;">
                                    Sign in
                                </button>
                            </div>
                        </form>
                        <p class="mt-3 mb-0">
                            Don't have an account?
                            <a class="text-primary" href="./join/signup">Register</a>
                        </p>
                        <p class="mt-3 mb-0">
                            Forgot Password
                            <a class="text-primary" href="reset-password.php">Click Here</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php

include_once($_SERVER['DOCUMENT_ROOT'] . "/auth/footer.php");

?>