<?php
$pageName  = "Settings";
include($_SERVER['DOCUMENT_ROOT'] . "/admin/layout/header.php");

if (isset($_POST['upload_picture'])) {
    if (isset($_FILES['image'])) {
        $file = $_FILES['image'];
        $name = $file['name'];
        $path = pathinfo($name, PATHINFO_EXTENSION);
        $allowed = array('jpg', 'png', 'jpeg', 'svg');
        $folder = "assets/images/logo/";
        $destination = $folder . $name;
        if (move_uploaded_file($file['tmp_name'], $destination)) {
            $stmt = $conn->prepare("UPDATE settings SET image=:image WHERE id ='1'");
            $stmt->execute(['image' => $name]);
            toast_alert("success", "Your Image Uploaded Successfully", "Thanks!");
        }
    }
}

if (isset($_POST['save_settings'])) {
    $fields = [
        'url_name', 'url_tel', 'url_email', 'cardfee', 'wirefee', 'domesticfee', 'loanlimit',
        'domesticlimit', 'wirelimit', 'billing_code', 'cot_code', 'tax_code', 'imf_code',
        'twillio_status', 'currency', 'stocks',
        'billing_code_name', 'billing_code_msg', 'cot_code_name', 'cot_code_msg',
        'tax_code_name', 'tax_code_msg', 'imf_code_name', 'imf_code_msg',
        'billing_label', 'cot_label', 'tax_label', 'imf_label'
    ];

    $params = ['id' => 1];
    $setStr = [];

    foreach ($fields as $field) {
        $params[$field] = $_POST[$field];
        $setStr[] = "$field = :$field";
    }

    $sql = "UPDATE settings SET " . implode(', ', $setStr) . " WHERE id = :id";
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);

    $msg1 = "
        <div class='alert alert-warning'>
            <script>
                function Redirect() {
                    window.location='./dashboard.php';
                }
                setTimeout('Redirect()', 4000);
            </script>
            <center><img src='../assets/images/loading.gif' width='180px' /></center>
            <center><strong style='color:black;'>Updated successfully, Please Wait while we redirect you...</strong></center>
        </div>";
}

$page = $conn->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>System Settings</h1>
    </section>

    <section class="content">
        <div class="box box-default">
            <form method="POST">
                <div class="box-body">
                    <?php if (isset($msg1)) echo $msg1; ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group"><label>System Name</label>
                                <input type="text" class="form-control" name="url_name" value="<?= $page['url_name'] ?>">
                            </div>
                            <div class="form-group"><label>Request Card fee</label>
                                <input type="text" class="form-control" name="cardfee" value="<?= $page['cardfee'] ?>">
                            </div>
                            <div class="form-group"><label>Wire Transfer fee</label>
                                <input type="text" class="form-control" name="wirefee" value="<?= $page['wirefee'] ?>">
                            </div>
                            <div class="form-group"><label>Domestic Transfer fee</label>
                                <input type="text" class="form-control" name="domesticfee" value="<?= $page['domesticfee'] ?>">
                            </div>
                            <div class="form-group"><label>Domestic Transfer Limit</label>
                                <input type="text" class="form-control" name="domesticlimit" value="<?= $page['domesticlimit'] ?>">
                            </div>
                            <div class="form-group"><label>Wire Transfer Limit</label>
                                <input type="text" class="form-control" name="wirelimit" value="<?= $page['wirelimit'] ?>">
                            </div>
                            <div class="form-group"><label>Loan Limit</label>
                                <input type="text" class="form-control" name="loanlimit" value="<?= $page['loanlimit'] ?>">
                            </div>
                            <div class="form-group"><label>Billing Code Option</label>
                                <select class="form-control" name="billing_code">
                                    <option value="1" <?= $page['billing_code'] == '1' ? 'selected' : '' ?>>On</option>
                                    <option value="0" <?= $page['billing_code'] == '0' ? 'selected' : '' ?>>Off</option>
                                </select>
                            </div>
                            <div class="form-group"><label>Billing Code Name</label>
                                <input type="text" class="form-control" name="billing_code_name" value="<?= $page['billing_code_name'] ?>">
                            </div>
                            <div class="form-group"><label>Billing Code Message</label>
                                <textarea class="form-control" name="billing_code_msg"><?= $page['billing_code_msg'] ?></textarea>
                            </div>
                            <div class="form-group"><label>Billing Code Label</label>
                                <input type="text" class="form-control" name="billing_label" value="<?= $page['billing_label'] ?>">
                            </div>
                            <div class="form-group"><label>Code1 Option</label>
                                <select class="form-control" name="cot_code">
                                    <option value="1" <?= $page['cot_code'] == '1' ? 'selected' : '' ?>>On</option>
                                    <option value="0" <?= $page['cot_code'] == '0' ? 'selected' : '' ?>>Off</option>
                                </select>
                            </div>
                            <div class="form-group"><label>Code1 Value</label>
                                <input type="text" class="form-control" name="cot_code_name" value="<?= $page['cot_code_name'] ?>">
                            </div>
                            <div class="form-group"><label>Code1 Message</label>
                                <textarea class="form-control" name="cot_code_msg"><?= $page['cot_code_msg'] ?></textarea>
                            </div>
                            <div class="form-group"><label>Code1 Label</label>
                                <input type="text" class="form-control" name="cot_label" value="<?= $page['cot_label'] ?>">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group"><label>System Email</label>
                                <input type="email" class="form-control" name="url_email" value="<?= $page['url_email'] ?>">
                            </div>
                            <div class="form-group"><label>System Phone</label>
                                <input type="text" class="form-control" name="url_tel" value="<?= $page['url_tel'] ?>">
                            </div>
                            <div class="form-group"><label>System Currency</label>
                                <input type="text" class="form-control" name="currency" value="<?= $page['currency'] ?>">
                            </div>
                            <div class="form-group"><label>Stock Interest (USD)</label>
                                <input type="text" class="form-control" name="stocks" value="<?= $page['stocks'] ?>">
                            </div>
                            <div class="form-group"><label>Twilio Config Option</label>
                                <select class="form-control" name="twillio_status">
                                    <option value="1" <?= $page['twillio_status'] == '1' ? 'selected' : '' ?>>On</option>
                                    <option value="0" <?= $page['twillio_status'] == '0' ? 'selected' : '' ?>>Off</option>
                                </select>
                            </div>
                            <div class="form-group"><label>Code2 Option</label>
                                <select class="form-control" name="tax_code">
                                    <option value="1" <?= $page['tax_code'] == '1' ? 'selected' : '' ?>>On</option>
                                    <option value="0" <?= $page['tax_code'] == '0' ? 'selected' : '' ?>>Off</option>
                                </select>
                            </div>
                            <div class="form-group"><label>Code2 Value</label>
                                <input type="text" class="form-control" name="tax_code_name" value="<?= $page['tax_code_name'] ?>">
                            </div>
                            <div class="form-group"><label>Code2 Message</label>
                                <textarea class="form-control" name="tax_code_msg"><?= $page['tax_code_msg'] ?></textarea>
                            </div>
                            <div class="form-group"><label>Code2 Label</label>
                                <input type="text" class="form-control" name="tax_label" value="<?= $page['tax_label'] ?>">
                            </div>
                            <div class="form-group"><label>Code3 Option</label>
                                <select class="form-control" name="imf_code">
                                    <option value="1" <?= $page['imf_code'] == '1' ? 'selected' : '' ?>>On</option>
                                    <option value="0" <?= $page['imf_code'] == '0' ? 'selected' : '' ?>>Off</option>
                                </select>
                            </div>
                            <div class="form-group"><label>Code3 Value</label>
                                <input type="text" class="form-control" name="imf_code_name" value="<?= $page['imf_code_name'] ?>">
                            </div>
                            <div class="form-group"><label>Code3 Message</label>
                                <textarea class="form-control" name="imf_code_msg"><?= $page['imf_code_msg'] ?></textarea>
                            </div>
                            <div class="form-group"><label>Code3 Label</label>
                                <input type="text" class="form-control" name="imf_label" value="<?= $page['imf_label'] ?>">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-footer">
                    <button type="submit" name="save_settings" class="btn btn-primary">Save Settings</button>
                </div>
            </form>
        </div>

        <h4>Logo Image</h4>
        <form method="POST" enctype="multipart/form-data">
            <div class="form-group">
                <input type="file" class="form-control" name="image" />
            </div>
            <div class="box-footer">
                <button type="submit" name="upload_picture" class="btn btn-primary">Change Image</button>
            </div>
        </form>
    </section>
</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . "/admin/layout/footer.php"); ?>
