<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Portfolio</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="kingswell-logo.jpeg" rel="icon">
  <link href="kingswell-logo.jpeg" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Inter:wght@100;200;300;400;500;600;700;800;900&family=Barlow:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="assets/css/main.css" rel="stylesheet">
</head>

<body class="portfolio-details-page">

<?php include("header.php"); ?>

  <main class="main">

    <!-- Page Title -->
    <div class="page-title dark-background" style="background-image: url(assets/img/bg/bg-14.webp);">
      <div class="container position-relative">
        <h1>Portfolio</h1>
        <p>Browse through our portfolio.</p>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="index.php">Home</a></li>
            <li class="current">Portfolio</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- Portfolio Details Section -->
    <section id="portfolio-details" class="portfolio-details section">

      <div class="container">

    <?php
include("connection.php"); // $conn must be defined

$itemsPerPage = 12;
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($page - 1) * $itemsPerPage;

// Fetch all distinct categories
$catResult = $conn->query("SELECT DISTINCT category FROM services ORDER BY category ASC");

while ($catRow = $catResult->fetch_assoc()):
  $category = $catRow['category'];

  // Total count for this category
  $countRes = $conn->prepare("SELECT COUNT(*) as total FROM services WHERE category = ?");
  $countRes->bind_param("s", $category);
  $countRes->execute();
  $countData = $countRes->get_result()->fetch_assoc();
  $totalItems = $countData['total'];
  $totalPages = ceil($totalItems / $itemsPerPage);

  // Fetch paginated items for this category
  $stmt = $conn->prepare("SELECT * FROM services WHERE category = ? ORDER BY id DESC LIMIT ?, ?");
  $stmt->bind_param("sii", $category, $offset, $itemsPerPage);
  $stmt->execute();
  $services = $stmt->get_result();
?>

<div class="project-gallery mt-5">
  <h3 class="mb-4"><?php echo htmlspecialchars($category); ?></h3>
  <div class="row g-3">
    <?php while ($row = $services->fetch_assoc()): ?>
      <div class="col-12 col-md-3">
        <div class="gallery-item">
          <a href="uploads/<?php echo htmlspecialchars($row['photo']); ?>" class="glightbox" data-gallery="services-<?php echo htmlspecialchars($category); ?>">
            <img src="uploads/<?php echo htmlspecialchars($row['photo']); ?>" alt="<?php echo htmlspecialchars($row['title']); ?>" class="img-fluid">
          </a>
        </div>
      </div>
    <?php endwhile; ?>
    <?php if ($services->num_rows === 0): ?>
      <div class="col-12"><p class="text-muted">No items in this category.</p></div>
    <?php endif; ?>
  </div>

  <!-- Pagination for this category -->
  <?php if ($totalPages > 1): ?>
    <nav class="mt-4">
      <ul class="pagination justify-content-center">
        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
          <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>">
            <a class="page-link" href="?page=<?php echo $i; ?>#<?php echo urlencode($category); ?>"><?php echo $i; ?></a>
          </li>
        <?php endfor; ?>
      </ul>
    </nav>
  <?php endif; ?>
</div>

<?php endwhile; ?>

         

          
        </div>

      </div>

    </section><!-- /Portfolio Details Section -->

  </main>

<?php include("footer.php"); ?>

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Preloader -->
  <div id="preloader">
    <div></div>
    <div></div>
    <div></div>
    <div></div>
  </div>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
  <script src="assets/vendor/purecounter/purecounter_vanilla.js"></script>
  <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>
  <script src="assets/vendor/imagesloaded/imagesloaded.pkgd.min.js"></script>
  <script src="assets/vendor/isotope-layout/isotope.pkgd.min.js"></script>

  <!-- Main JS File -->
  <script src="assets/js/main.js"></script>

</body>

</html>