<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Kingswell Aluminium Company</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="kingswell-logo.jpeg" rel="icon">
  <link href="kingswell-logo.jpeg" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Inter:wght@100;200;300;400;500;600;700;800;900&family=Barlow:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">
  
  <!-- Glightbox CSS -->
<link href="https://cdn.jsdelivr.net/npm/glightbox/dist/css/glightbox.min.css" rel="stylesheet" />
<!-- Glightbox JS -->
<script src="https://cdn.jsdelivr.net/npm/glightbox/dist/js/glightbox.min.js"></script>
<script>
  const lightbox = GLightbox({ selector: '.glightbox' });
</script>


  <!-- Main CSS File -->
  <link href="assets/css/main.css" rel="stylesheet">
</head>

<body class="index-page">

<?php
include("header.php");
?>

  <main class="main">

 <!-- Hero Section -->
<section id="hero" class="hero section dark-background">

  <div class="hero-background">
    <img src="assets/img/bg/bg-14.webp" alt="" data-aos-duration="1000">
    <div class="overlay"></div>
  </div>

  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-6">
        <div class="hero-content">
          <span class="hero-badge">Welcome To</span>
          <h1>Kingswell Aluminium Company</h1>
          <p>
            We specialize in aluminium roofing, windows, glass installations, panel boards, stainless steel works, aluminium sales, and general building construction.
          </p>

         <div class="hero-actions" style="display: flex; flex-wrap: nowrap; gap: 10px; flex-direction: row; justify-content: start; align-items: center;">
  <a href="#services" class="btn-primary" style="white-space: nowrap;">Explore Services</a>

  <!-- Single Watch Video Button -->
  <a href="vid1.mp4" class="btn-secondary glightbox" data-type="video" style="white-space: nowrap;">
    <i class="bi bi-play-circle"></i>
    <span>Our Works</span>
  </a>
</div>


         <div class="hero-stats" style="display: flex; flex-wrap: nowrap; gap: 10px; flex-direction: row; justify-content: start; align-items: center;">
  <div class="stat-item" style="white-space: nowrap;">
    <span class="stat-number">Exceptional</span><br>
    <span class="stat-label">Project Delivery</span>
  </div>
  <div class="stat-item" style="white-space: nowrap;">
    <span class="stat-number">Reliable</span><br>
    <span class="stat-label">Customer Relationships</span>
  </div>
</div>


        </div>
      </div>

      <div class="col-lg-6">
        <div class="hero-visual">
          <div class="row g-3">
            <div class="col-6">
              <div class="feature-card">
                <i class="bi bi-shield-check"></i>
                <span>Strong & Safe</span>
              </div>
              <div class="feature-card">
                <i class="bi bi-people"></i>
                <span>Skilled Team</span>
              </div>
            </div>
            <div class="col-6">
              <div class="feature-card">
                <i class="bi bi-speedometer2"></i>
                <span>Fast Work</span>
              </div>
              <div class="feature-card">
                <i class="bi bi-award"></i>
                <span>Top Rated</span>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>

</section>
<!-- /Hero Section -->


    <!-- Portfolio Section -->
<section id="portfolio" class="portfolio section">

  <!-- Section Title -->
  <div class="container section-title">
    <h2>Our Work</h2>
    <p>Explore some of our completed projects at Kingswell Aluminium Company.</p>
  </div>

  <div class="container">
    <div class="isotope-layout" data-default-filter="*" data-layout="masonry" data-sort="original-order">
      
      <!-- Filters -->
      <div class="row">
        <div class="col-lg-12 d-flex justify-content-center mt-4">
          <ul class="portfolio-filters isotope-filters">
            <li data-filter="*" class="filter-active">All</li>
            <li data-filter=".filter-roofing">Aluminium Roofing</li>
            <li data-filter=".filter-windows">Windows & Doors</li>
            <li data-filter=".filter-glass">Glass Works</li>
            <li data-filter=".filter-panels">Aluminium Panels</li>
            <li data-filter=".filter-stainless">Stainless Works</li>
            <li data-filter=".filter-construction">Building Construction</li>
          </ul>
        </div>
      </div>

      <!-- Portfolio Items -->
      <div class="row gy-4 portfolio-container isotope-container">

        <!-- Aluminium Roofing -->
        <?php
          for ($i = 1; $i <= 5; $i++) {
            echo '
            <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-roofing">
              <div class="portfolio-wrap">
                <img src="al-roofing' . $i . '.jpg" class="img-fluid" alt="Aluminium Roofing">
                <div class="portfolio-info">
                  <h4>Aluminium Roofing ' . $i . '</h4>
                  <p>Durable and stylish</p>
                  <div class="portfolio-links">
                    <a href="al-roofing' . $i . '.jpg" class="glightbox" title="Aluminium Roofing ' . $i . '"><i class="bi bi-zoom-in"></i></a>
                  </div>
                </div>
              </div>
            </div>';
          }
        ?>

        <!-- Windows & Doors -->
        <?php
          for ($i = 1; $i <= 5; $i++) {
            echo '
            <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-windows">
              <div class="portfolio-wrap">
                <img src="w-d' . $i . '.jpg" class="img-fluid" alt="Windows and Doors">
                <div class="portfolio-info">
                  <h4>Windows & Doors ' . $i . '</h4>
                  <p>Secure and elegant</p>
                  <div class="portfolio-links">
                    <a href="w-d' . $i . '.jpg" class="glightbox" title="Windows & Doors ' . $i . '"><i class="bi bi-zoom-in"></i></a>
                  </div>
                </div>
              </div>
            </div>';
          }
        ?>

        <!-- Glass Works -->
        <?php
          for ($i = 1; $i <= 4; $i++) {
            echo '
            <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-glass">
              <div class="portfolio-wrap">
                <img src="glass-works' . $i . '.jpg" class="img-fluid" alt="Glass Works">
                <div class="portfolio-info">
                  <h4>Glass Work ' . $i . '</h4>
                  <p>Elegant finishing</p>
                  <div class="portfolio-links">
                    <a href="glass-works' . $i . '.jpg" class="glightbox" title="Glass Work ' . $i . '"><i class="bi bi-zoom-in"></i></a>
                  </div>
                </div>
              </div>
            </div>';
          }
        ?>

        <!-- Aluminium Panels -->
        <?php
          for ($i = 1; $i <= 3; $i++) {
            echo '
            <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-panels">
              <div class="portfolio-wrap">
                <img src="al-panel' . $i . '.jpg" class="img-fluid" alt="Aluminium Panels">
                <div class="portfolio-info">
                  <h4>Aluminium Panel ' . $i . '</h4>
                  <p>Exterior & interior design</p>
                  <div class="portfolio-links">
                    <a href="al-panel' . $i . '.jpg" class="glightbox" title="Aluminium Panel ' . $i . '"><i class="bi bi-zoom-in"></i></a>
                  </div>
                </div>
              </div>
            </div>';
          }
        ?>

        <!-- Stainless Works -->
        <?php
          for ($i = 1; $i <= 2; $i++) {
            echo '
            <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-stainless">
              <div class="portfolio-wrap">
                <img src="stainless' . $i . '.jpg" class="img-fluid" alt="Stainless Works">
                <div class="portfolio-info">
                  <h4>Stainless Work ' . $i . '</h4>
                  <p>Rust-free and strong</p>
                  <div class="portfolio-links">
                    <a href="stainless' . $i . '.jpg" class="glightbox" title="Stainless Work ' . $i . '"><i class="bi bi-zoom-in"></i></a>
                  </div>
                </div>
              </div>
            </div>';
          }
        ?>

        <!-- Building Construction -->
        <?php
          for ($i = 1; $i <= 3; $i++) {
            echo '
            <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-construction">
              <div class="portfolio-wrap">
                <img src="bc' . $i . '.jpg" class="img-fluid" alt="Building Construction">
                <div class="portfolio-info">
                  <h4>Building Construction ' . $i . '</h4>
                  <p>Foundation to finish</p>
                  <div class="portfolio-links">
                    <a href="bc' . $i . '.jpg" class="glightbox" title="Building Construction ' . $i . '"><i class="bi bi-zoom-in"></i></a>
                  </div>
                </div>
              </div>
            </div>';
          }
        ?>

      </div><!-- End Portfolio Container -->

    </div>
  </div>
</section><!-- /Portfolio Section -->


  <!-- About Section -->
<section id="about" class="about section">

  <div class="container">

    <div class="row align-items-center">
      <div class="col-lg-6">
        <div class="content">
          <h2>Building with Precision and Excellence</h2>
          <p class="lead">At Kingswell Aluminium Company, we specialize in delivering high-quality aluminium solutions for residential, commercial, and industrial projects.</p>
          <p>We’ve been a trusted name in aluminium roofing, windows, glass installations, panel boards, stainless steel works, and general building construction. Our commitment to craftsmanship, innovation, and client satisfaction sets us apart in the industry.</p>
          <p>From concept to completion, we work closely with our clients to bring their vision to life with durable materials, expert design, and reliable service. Our team is dedicated to ensuring every project is completed with precision and professionalism.</p>

         <div class="stats-container">
  <div class="row">
    <div class="col-md-4">
      <div class="stat-item">
        <div class="label">Service You Can Trust</div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="stat-item">
        <div class="label">Experts in Aluminium Solutions</div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="stat-item">
        <div class="label">Committed to Quality Craftsmanship</div>
      </div>
    </div>
  </div>
</div>


          <div class="cta-wrapper">
            <a href="portfolio.php" class="btn btn-primary">View Our Projects</a>
            <a href="tel:+234 703 948 6164" class="btn btn-outline">Give Us a Call</a>
          </div>
        </div>
      </div>

      <div class="col-lg-6">
        <div class="image-wrapper">
          <img src="1.jpg" alt="About Kingswell Aluminium" class="img-fluid main-image">
          <div class="floating-card">
            <div class="card-content">
              <i class="bi bi-award"></i>
              <div class="text">
                <h5>Industry Recognition</h5>
                <span>Excellence in Aluminium Works</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>

</section><!-- /About Section -->


    <!-- Clients Section 
    <section id="clients" class="clients section">

      <div>

        <div class="clients-slider swiper init-swiper">
          <script type="application/json" class="swiper-config">
            {
              "loop": true,
              "speed": 6000,
              "autoplay": {
                "delay": 1,
                "disableOnInteraction": false
              },
              "centeredSlides": true,
              "slideToClickedSlide": true,
              "slidesPerView": "auto",
              "spaceBetween": 40,
              "breakpoints": {
                "320": {
                  "slidesPerView": 2,
                  "spaceBetween": 20
                },
                "640": {
                  "slidesPerView": 3,
                  "spaceBetween": 20
                },
                "992": {
                  "slidesPerView": 4,
                  "spaceBetween": 30
                },
                "1200": {
                  "slidesPerView": 6,
                  "spaceBetween": 40
                }
              }
            }
          </script>

          <div class="swiper-wrapper">
            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-1.webp" class="img-fluid" alt="">
              </div>
            </div>

            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-2.webp" class="img-fluid" alt="">
              </div>
            </div>

            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-3.webp" class="img-fluid" alt="">
              </div>
            </div>

            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-4.webp" class="img-fluid" alt="">
              </div>
            </div>

            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-5.webp" class="img-fluid" alt="">
              </div>
            </div>

            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-6.webp" class="img-fluid" alt="">
              </div>
            </div>

            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-1.webp" class="img-fluid" alt="">
              </div>
            </div>

            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-2.webp" class="img-fluid" alt="">
              </div>
            </div>

            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-3.webp" class="img-fluid" alt="">
              </div>
            </div>

            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-4.webp" class="img-fluid" alt="">
              </div>
            </div>

            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-5.webp" class="img-fluid" alt="">
              </div>
            </div>

            <div class="swiper-slide">
              <div class="client-logo">
                <img src="assets/img/clients/clients-6.webp" class="img-fluid" alt="">
              </div>
            </div> 

          </div>

        </div>

      </div>

    </section> -->

    <!-- Featured Services Section 
    <section id="featured-services" class="featured-services section light-background">

      
      <div class="container section-title">
        <h2>Featured Services</h2>
        <p>Featured Srvices</p>
      </div>

      <div class="container">

        <div class="row">
          <div class="col-lg-6">
            <div class="services-content" data-aos-duration="900">
              <span class="subtitle">Professional Services</span>
              <h2>Elevating Business Performance Through Strategic Solutions</h2>
              <p data-aos-duration="800">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent varius risus sed pellentesque auctor. Phasellus gravida magna at tortor cursus, sit amet suscipit tortor malesuada.</p>
              <div class="mt-4" data-aos-duration="1100">
                <a href="#" class="btn-consultation"><span>Request a Consultation</span><i class="bi bi-arrow-right"></i></a>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="services-image">
              <img src="assets/img/services/services-9.webp" alt="Business Services" class="img-fluid">
              <div class="shape-circle"></div>
              <div class="shape-accent"></div>
            </div>
          </div>
        </div>

        <div class="row mt-5" data-aos-duration="1000">
          <div class="col-12">
            <div class="services-slider swiper init-swiper">
              <script type="application/json" class="swiper-config">
                {
                  "slidesPerView": 3,
                  "spaceBetween": 20,
                  "loop": true,
                  "speed": 600,
                  "autoplay": {
                    "delay": 5000
                  },
                  "navigation": {
                    "nextEl": ".swiper-nav-next",
                    "prevEl": ".swiper-nav-prev"
                  },
                  "breakpoints": {
                    "320": {
                      "slidesPerView": 1
                    },
                    "768": {
                      "slidesPerView": 2
                    },
                    "992": {
                      "slidesPerView": 3
                    }
                  }
                }
              </script>
              <div class="swiper-wrapper">

                <div class="swiper-slide">
                  <div class="service-card">
                    <div class="icon-box">
                      <i class="bi bi-bar-chart-fill"></i>
                    </div>
                    <a href="#" class="arrow-link"><i class="bi bi-arrow-right"></i></a>
                    <div class="content">
                      <h4><a href="#">Financial Strategy Development</a></h4>
                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla facilisi. Cras vehicula magna eget lectus varius, at finibus massa condimentum.</p>
                      <div class="service-number">01</div>
                    </div>
                  </div>
                </div>

                <div class="swiper-slide">
                  <div class="service-card">
                    <div class="icon-box">
                      <i class="bi bi-graph-up-arrow"></i>
                    </div>
                    <a href="#" class="arrow-link"><i class="bi bi-arrow-right"></i></a>
                    <div class="content">
                      <h4><a href="#">Market Expansion Advisory</a></h4>
                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla facilisi. Cras vehicula magna eget lectus varius, at finibus massa condimentum.</p>
                      <div class="service-number">02</div>
                    </div>
                  </div>
                </div>

                <div class="swiper-slide">
                  <div class="service-card">
                    <div class="icon-box">
                      <i class="bi bi-shield-check"></i>
                    </div>
                    <a href="#" class="arrow-link"><i class="bi bi-arrow-right"></i></a>
                    <div class="content">
                      <h4><a href="#">Risk Management Solutions</a></h4>
                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla facilisi. Cras vehicula magna eget lectus varius, at finibus massa condimentum.</p>
                      <div class="service-number">03</div>
                    </div>
                  </div>
                </div>

                <div class="swiper-slide">
                  <div class="service-card">
                    <div class="icon-box">
                      <i class="bi bi-lightbulb-fill"></i>
                    </div>
                    <a href="#" class="arrow-link"><i class="bi bi-arrow-right"></i></a>
                    <div class="content">
                      <h4><a href="#">Innovation &amp; Digital Transformation</a></h4>
                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla facilisi. Cras vehicula magna eget lectus varius, at finibus massa condimentum.</p>
                      <div class="service-number">04</div>
                    </div>
                  </div>
                </div>

                <div class="swiper-slide">
                  <div class="service-card">
                    <div class="icon-box">
                      <i class="bi bi-people-fill"></i>
                    </div>
                    <a href="#" class="arrow-link"><i class="bi bi-arrow-right"></i></a>
                    <div class="content">
                      <h4><a href="#">Talent Management Strategy</a></h4>
                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla facilisi. Cras vehicula magna eget lectus varius, at finibus massa condimentum.</p>
                      <div class="service-number">05</div>
                    </div>
                  </div>
                </div>

              </div>
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-12">
            <div class="swiper-navigation">
              <button class="swiper-nav-prev"><i class="bi bi-chevron-left"></i></button>
              <button class="swiper-nav-next"><i class="bi bi-chevron-right"></i></button>
            </div>
          </div>
        </div>

      </div>

    </section>Featured Services Section -->

  <!-- How We Work Section -->
<section id="how-we-work" class="how-we-work section">

  <!-- Section Title -->
  <div class="container section-title">
    <h2>How We Work</h2>
    <p>Simple steps we follow to deliver quality work, on time and on budget.</p>
  </div><!-- End Section Title -->

  <div class="container">

    <div class="steps-grid">
      <div class="step-card">
        <div class="step-icon">
          <i class="bi bi-search"></i>
        </div>
        <div class="step-number">Step 1</div>
        <h3>Site Check</h3>
        <p>We visit or review the site and understand what’s needed for your project.</p>
        <div class="step-arrow">
          <i class="bi bi-arrow-right"></i>
        </div>
      </div>

      <div class="step-card">
        <div class="step-icon">
          <i class="bi bi-lightbulb"></i>
        </div>
        <div class="step-number">Step 2</div>
        <h3>Plan & Quote</h3>
        <p>We plan the job, choose the right materials, and send you a clear quote.</p>
        <div class="step-arrow">
          <i class="bi bi-arrow-right"></i>
        </div>
      </div>

      <div class="step-card">
        <div class="step-icon">
          <i class="bi bi-gear"></i>
        </div>
        <div class="step-number">Step 3</div>
        <h3>Work Starts</h3>
        <p>Our team gets to work — safe, neat, and focused on quality from day one.</p>
        <div class="step-arrow">
          <i class="bi bi-arrow-right"></i>
        </div>
      </div>

      <div class="step-card">
        <div class="step-icon">
          <i class="bi bi-rocket-takeoff"></i>
        </div>
        <div class="step-number">Step 4</div>
        <h3>Finish & Support</h3>
        <p>We finish the job on time and remain available for any follow-up support.</p>
      </div>
    </div>

  </div>

</section><!-- /How We Work Section -->

<!-- Features Section -->
<section id="features" class="features section">
  <div class="container">
    <div class="row g-4">
      <div class="col-lg-4">
        <ul class="nav nav-tabs flex-column" role="tablist">
          <li class="nav-item">
            <a class="nav-link active" data-bs-toggle="tab" data-bs-target="#features-tab-1" role="tab">
              <div class="d-flex align-items-center">
                <div class="icon-box"><i class="bi bi-house-door"></i></div>
                <div class="ms-3">
                  <h4>Aluminium Roofing</h4>
                  <p>Strong and long-lasting sheets</p>
                </div>
              </div>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" data-bs-target="#features-tab-2" role="tab">
              <div class="d-flex align-items-center">
                <div class="icon-box"><i class="bi bi-windows"></i></div>
                <div class="ms-3">
                  <h4>Aluminium Windows</h4>
                  <p>Neat, strong and easy to fix</p>
                </div>
              </div>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" data-bs-target="#features-tab-3" role="tab">
              <div class="d-flex align-items-center">
                <div class="icon-box"><i class="bi bi-columns-gap"></i></div>
                <div class="ms-3">
                  <h4>Glass Works</h4>
                  <p>Clean glass for doors and rails</p>
                </div>
              </div>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" data-bs-target="#features-tab-4" role="tab">
              <div class="d-flex align-items-center">
                <div class="icon-box"><i class="bi bi-tools"></i></div>
                <div class="ms-3">
                  <h4>Stainless Jobs</h4>
                  <p>Nice steel work for homes</p>
                </div>
              </div>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" data-bs-target="#features-tab-5" role="tab">
              <div class="d-flex align-items-center">
                <div class="icon-box"><i class="bi bi-building"></i></div>
                <div class="ms-3">
                  <h4>Construction</h4>
                  <p>We build from start to end</p>
                </div>
              </div>
            </a>
          </li>
        </ul>
      </div>

      <div class="col-lg-8">
        <div class="tab-content">
          <div class="tab-pane fade active show" id="features-tab-1" role="tabpanel">
            <div class="content-box">
              <div class="row g-4">
                <div class="col-lg-6">
                  <h3>Aluminium Roofing</h3>
                  <p>We make and fix light but tough roof sheets. Great for all types of homes and sites.</p>
                  <p class="highlight">We offer long-span, step-tile, and other types – shaped to your needs.</p>
                  <ul class="features-list">
                    <li><i class="bi bi-check2-circle"></i> Light but strong</li>
                    <li><i class="bi bi-check2-circle"></i> Many colors and looks</li>
                    <li><i class="bi bi-check2-circle"></i> Blocks heat and noise</li>
                    <li><i class="bi bi-check2-circle"></i> Clean and rust-free</li>
                  </ul>
                </div>
                <div class="col-lg-6">
                  <div class="image-box">
                    <img src="alu-roof.jpg" alt="Aluminium Roofing" class="img-fluid" loading="lazy">
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="tab-pane fade" id="features-tab-2" role="tabpanel">
            <div class="content-box">
              <div class="row g-4">
                <div class="col-lg-6">
                  <h3>Aluminium Windows</h3>
                  <p>We supply and fix top-grade window frames. Neat lines, safe fit, no stress.</p>
                  <p class="highlight">Slim, strong, and clean – for homes and workspaces.</p>
                  <ul class="features-list">
                    <li><i class="bi bi-check2-circle"></i> Sleek look</li>
                    <li><i class="bi bi-check2-circle"></i> No rust</li>
                    <li><i class="bi bi-check2-circle"></i> Easy to clean</li>
                    <li><i class="bi bi-check2-circle"></i> Fast install</li>
                  </ul>
                </div>
                <div class="col-lg-6">
                  <div class="image-box">
                    <img src="aluminium-window.jpg" alt="Aluminium Windows" class="img-fluid" loading="lazy">
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="tab-pane fade" id="features-tab-3" role="tabpanel">
            <div class="content-box">
              <div class="row g-4">
                <div class="col-lg-6">
                  <h3>Glass Works</h3>
                  <p>We cut and fix glass for homes, shops, and more. Clear, strong, and safe.</p>
                  <p class="highlight">Best for doors, rails, and walls – made to fit your style.</p>
                  <ul class="features-list">
                    <li><i class="bi bi-check2-circle"></i> Clear view</li>
                    <li><i class="bi bi-check2-circle"></i> Safe and neat</li>
                    <li><i class="bi bi-check2-circle"></i> Easy to wipe</li>
                    <li><i class="bi bi-check2-circle"></i> Fine finish</li>
                  </ul>
                </div>
                <div class="col-lg-6">
                  <div class="image-box">
                    <img src="glass-works.jpg" alt="Glass Works" class="img-fluid" loading="lazy">
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="tab-pane fade" id="features-tab-4" role="tabpanel">
            <div class="content-box">
              <div class="row g-4">
                <div class="col-lg-6">
                  <h3>Stainless Jobs</h3>
                  <p>We build gates, rails, and more using top steel. Clean look that lasts long.</p>
                  <p class="highlight">Neat welds and custom shapes. Fit for any space.</p>
                  <ul class="features-list">
                    <li><i class="bi bi-check2-circle"></i> Rust-proof</li>
                    <li><i class="bi bi-check2-circle"></i> Long life</li>
                    <li><i class="bi bi-check2-circle"></i> Smart look</li>
                    <li><i class="bi bi-check2-circle"></i> Custom size</li>
                  </ul>
                </div>
                <div class="col-lg-6">
                  <div class="image-box">
                    <img src="stainless.jpg" alt="Stainless Work" class="img-fluid" loading="lazy">
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="tab-pane fade" id="features-tab-5" role="tabpanel">
            <div class="content-box">
              <div class="row g-4">
                <div class="col-lg-6">
                  <h3>Construction</h3>
                  <p>We build homes, shops, and more. Full service from base to roof.</p>
                  <p class="highlight">We plan, supply, and build with care – no stress for you.</p>
                  <ul class="features-list">
                    <li><i class="bi bi-check2-circle"></i> Full build jobs</li>
                    <li><i class="bi bi-check2-circle"></i> On-time work</li>
                    <li><i class="bi bi-check2-circle"></i> Solid team</li>
                    <li><i class="bi bi-check2-circle"></i> No cut corners</li>
                  </ul>
                </div>
                <div class="col-lg-6">
                  <div class="image-box">
                    <img src="https://media.istockphoto.com/id/847503126/photo/unfinished-building-on-construction-site.jpg?s=612x612&w=0&k=20&c=UgGDQtQ-74_mNuVKXjXOq5n6eQA_363xkVTVINBgqHc=" alt="Construction" class="img-fluid" loading="lazy">
                  </div>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>
<!-- /Features Section -->

<!-- Services Section -->
<section id="services" class="services section light-background">

  <!-- Section Title -->
  <div class="container section-title">
    <h2>Services</h2>
    <p>WHAT WE OFFER</p>
  </div>

  <div class="container">

    <div class="row gy-4">

      <div class="col-lg-6 col-md-6">
        <div class="service-card featured">
          <div class="service-icon">
            <i class="bi bi-house-door"></i>
          </div>
          <div class="service-content">
            <h3>Aluminium Windows</h3>
            <p>We craft durable and stylish aluminium windows tailored to your space and design preference.</p>
            <div class="service-meta">
              <span class="badge popular">Most Popular</span>
            </div>
            <a href="tel:+2347039486164" class="btn-cta">
              <span>Learn More</span>
              <i class="bi bi-arrow-right"></i>
            </a>
          </div>
        </div>
      </div>

      <div class="col-lg-6 col-md-6">
        <div class="service-card">
          <div class="service-icon">
            <i class="bi bi-door-closed"></i>
          </div>
          <div class="service-content">
            <h3>Aluminium Doors</h3>
            <p>Strong and elegant aluminium doors suitable for both home and office environments.</p>
            <a href="tel:+2347039486164" class="btn-cta">
              <span>Learn More</span>
              <i class="bi bi-arrow-right"></i>
            </a>
          </div>
        </div>
      </div>

      <div class="col-lg-4 col-md-6">
        <div class="service-card compact">
          <div class="service-icon">
            <i class="bi bi-columns-gap"></i>
          </div>
          <div class="service-content">
            <h3>Office Partitions</h3>
            <p>Custom aluminium partitioning to organize your office for privacy and productivity.</p>
            <a href="tel:+2347039486164" class="btn-cta">
              <span>Learn More</span>
              <i class="bi bi-arrow-right"></i>
            </a>
          </div>
        </div>
      </div>

      <div class="col-lg-4 col-md-6">
        <div class="service-card compact">
          <div class="service-icon">
            <i class="bi bi-droplet-half"></i>
          </div>
          <div class="service-content">
            <h3>Shower Cubicles</h3>
            <p>Modern and sleek aluminium-framed shower enclosures for residential and commercial bathrooms.</p>
            <a href="tel:+2347039486164" class="btn-cta">
              <span>Learn More</span>
              <i class="bi bi-arrow-right"></i>
            </a>
          </div>
        </div>
      </div>

      <div class="col-lg-4 col-md-6">
        <div class="service-card compact">
          <div class="service-icon">
            <i class="bi bi-grid-3x3-gap-fill"></i>
          </div>
          <div class="service-content">
            <h3>Wall Cladding</h3>
            <p>Protect and enhance your building’s exterior or interior with durable aluminium cladding.</p>
            <a href="tel:+2347039486164" class="btn-cta">
              <span>Learn More</span>
              <i class="bi bi-arrow-right"></i>
            </a>
          </div>
        </div>
      </div>

    </div>

    <!-- Stats -->
    <div class="stats-highlight mt-5">
      <div class="row">
        <div class="col-lg-3 col-md-6">
          <div class="stat-item">
            <div class="stat-number" style="font-size: 30px;">Proven</div>
            <div class="stat-label">Track Record of Excellence</div>
          </div>
        </div>
        <div class="col-lg-3 col-md-6">
          <div class="stat-item">
            <div class="stat-number" style="font-size: 30px;">Trusted</div>
            <div class="stat-label">By Clients Nationwide</div>
          </div>
        </div>
        <div class="col-lg-3 col-md-6">
          <div class="stat-item">
            <div class="stat-number" style="font-size: 30px;">Responsive</div>
            <div class="stat-label">Support When You Need It</div>
          </div>
        </div>
        <div class="col-lg-3 col-md-6">
          <div class="stat-item">
            <div class="stat-number" style="font-size: 30px;">Experienced</div>
            <div class="stat-label">In Aluminium and Construction</div>
          </div>
        </div>
      </div>
    </div>

  </div>
</section>



  

    <!-- Testimonials Section 
    <section id="testimonials" class="testimonials section">

      <div class="container">

        <div class="swiper init-swiper">
          <script type="application/json" class="swiper-config">
            {
              "loop": true,
              "speed": 600,
              "autoplay": {
                "delay": 5000
              },
              "slidesPerView": "auto",
              "pagination": {
                "el": ".swiper-pagination",
                "type": "bullets",
                "clickable": true
              },
              "breakpoints": {
                "320": {
                  "slidesPerView": 1,
                  "spaceBetween": 40
                },
                "1200": {
                  "slidesPerView": 3,
                  "spaceBetween": 1
                }
              }
            }
          </script>
          <div class="swiper-wrapper">

            <div class="swiper-slide">
              <div class="testimonial-item">
                <p>
                  <i class="bi bi-quote quote-icon-left"></i>
                  <span>Proin iaculis purus consequat sem cure digni ssim donec porttitora entum suscipit rhoncus. Accusantium quam, ultricies eget id, aliquam eget nibh et. Maecen aliquam, risus at semper.</span>
                  <i class="bi bi-quote quote-icon-right"></i>
                </p>
                <img src="assets/img/person/person-m-9.webp" class="testimonial-img" alt="">
                <h3>Saul Goodman</h3>
                <h4>Ceo &amp; Founder</h4>
              </div>
            </div>

            <div class="swiper-slide">
              <div class="testimonial-item">
                <p>
                  <i class="bi bi-quote quote-icon-left"></i>
                  <span>Export tempor illum tamen malis malis eram quae irure esse labore quem cillum quid malis quorum velit fore eram velit sunt aliqua noster fugiat irure amet legam anim culpa.</span>
                  <i class="bi bi-quote quote-icon-right"></i>
                </p>
                <img src="assets/img/person/person-f-5.webp" class="testimonial-img" alt="">
                <h3>Sara Wilsson</h3>
                <h4>Designer</h4>
              </div>
            </div>

            <div class="swiper-slide">
              <div class="testimonial-item">
                <p>
                  <i class="bi bi-quote quote-icon-left"></i>
                  <span>Enim nisi quem export duis labore cillum quae magna enim sint quorum nulla quem veniam duis minim tempor labore quem eram duis noster aute amet eram fore quis sint minim.</span>
                  <i class="bi bi-quote quote-icon-right"></i>
                </p>
                <img src="assets/img/person/person-f-12.webp" class="testimonial-img" alt="">
                <h3>Jena Karlis</h3>
                <h4>Store Owner</h4>
              </div>
            </div> 

            <div class="swiper-slide">
              <div class="testimonial-item">
                <p>
                  <i class="bi bi-quote quote-icon-left"></i>
                  <span>Fugiat enim eram quae cillum dolore dolor amet nulla culpa multos export minim fugiat dolor enim duis veniam ipsum anim magna sunt elit fore quem dolore labore illum veniam.</span>
                  <i class="bi bi-quote quote-icon-right"></i>
                </p>
                <img src="assets/img/person/person-m-12.webp" class="testimonial-img" alt="">
                <h3>Matt Brandon</h3>
                <h4>Freelancer</h4>
              </div>
            </div>

            <div class="swiper-slide">
              <div class="testimonial-item">
                <p>
                  <i class="bi bi-quote quote-icon-left"></i>
                  <span>Quis quorum aliqua sint quem legam fore sunt eram irure aliqua veniam tempor noster veniam sunt culpa nulla illum cillum fugiat legam esse veniam culpa fore nisi cillum quid.</span>
                  <i class="bi bi-quote quote-icon-right"></i>
                </p>
                <img src="assets/img/person/person-m-13.webp" class="testimonial-img" alt="">
                <h3>John Larson</h3>
                <h4>Entrepreneur</h4>
              </div>
            </div>

          </div>
          <div class="swiper-pagination"></div>
        </div>

      </div>

    </section><!-- /Testimonials Section -->



 <!-- Contact Section -->
<section id="contact" class="contact section">
  <!-- Section Title -->
  <div class="container section-title">
    <h2>Contact</h2>
    <p>Reach out to Kingswell Aluminium Company for all your aluminium and building needs.</p>
  </div>

  <div class="container">
    <div class="contact-main-wrapper">
      <div class="map-wrapper">
      <iframe
  src="https://www.google.com/maps?q=6.334430,5.603880&z=17&output=embed"
  width="600"
  height="450"
  style="border:0;"
  allowfullscreen=""
  loading="lazy"
  referrerpolicy="no-referrer-when-downgrade">
</iframe>


      </div>

      <div class="contact-content">
        <div class="contact-cards-container">
          <div class="contact-card">
            <div class="icon-box"><i class="bi bi-geo-alt"></i></div>
            <div class="contact-text">
              <h4>Location</h4>
              <p> 📍 Km 15, Benin Sapele Road, By FreeTown Hotel & Suite Junction, Okha, Benin city.</p>
            </div>
          </div>

          <div class="contact-card">
            <div class="icon-box"><i class="bi bi-envelope"></i></div>
            <div class="contact-text">
              <h4>Email</h4>
              <p>contact@kingswellaluminiumcompany.com.ng</p>
            </div>
          </div>

          <div class="contact-card">
            <div class="icon-box"><i class="bi bi-telephone"></i></div>
            <div class="contact-text">
              <h4>Call Line 1</h4>
              <p><a href="tel:+2347039486164">+234 703 948 6164</a></p>
            </div>
          </div>

          <div class="contact-card">
            <div class="icon-box"><i class="bi bi-telephone"></i></div>
            <div class="contact-text">
              <h4>Call Line 2</h4>
              <p><a href="tel:+2349052155359">+234 905 215 5359</a></p>
            </div>
          </div>
        </div>

        <div class="contact-form-container">
          <h3>Get in Touch</h3>
          <p>Send us a quick message on WhatsApp and we’ll respond promptly.</p>

          <form onsubmit="event.preventDefault(); sendToWhatsApp();">
            <div class="row">
              <div class="col-md-6 form-group">
                <input type="text" name="name" class="form-control" id="name" placeholder="Your Name" required>
              </div>
              <div class="col-md-6 form-group mt-3 mt-md-0">
                <input type="text" class="form-control" name="subject" id="subject" placeholder="Subject" required>
              </div>
            </div>
            <div class="form-group mt-3">
              <textarea class="form-control" name="message" id="message" rows="5" placeholder="Message" required></textarea>
            </div>

            <div class="form-submit mt-3">
              <button type="submit" class="btn btn-success btn-lg">Send via WhatsApp</button>
            </div>
          </form>

          <script>
            function sendToWhatsApp() {
              const name = document.getElementById("name").value;
              const subject = document.getElementById("subject").value;
              const message = document.getElementById("message").value;

              const phoneNumber = "2347039486164";
              const text = `Hello Kingswell Aluminium Company,%0A%0AMy name is ${name}.%0ASubject: ${subject}%0AMessage: ${message}`;
              const whatsappURL = `https://wa.me/${phoneNumber}?text=${text}`;
              window.open(whatsappURL, '_blank');
            }
          </script>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- /Contact Section -->

  </main>

<?php include("footer.php"); ?>

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Preloader -->
  <div id="preloader">
    <div></div>
    <div></div>
    <div></div>
    <div></div>
  </div>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
  <script src="assets/vendor/purecounter/purecounter_vanilla.js"></script>
  <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>
  <script src="assets/vendor/imagesloaded/imagesloaded.pkgd.min.js"></script>
  <script src="assets/vendor/isotope-layout/isotope.pkgd.min.js"></script>

  <!-- Main JS File -->
  <script src="assets/js/main.js"></script>

</body>

</html>