<?php
session_start();
include('connection.php'); // Make sure this defines $conn

if (!isset($_GET['id'])) {
    header("Location: add-services.php");
    exit();
}

$id = (int) $_GET['id'];
$service = $conn->query("SELECT * FROM services WHERE id = $id")->fetch_assoc();

if (!$service) {
    echo "Service not found.";
    exit();
}

// Handle update
if (isset($_POST['update'])) {
    $category = trim($_POST['category']);
    $title = trim($_POST['title']);
    $oldPhoto = $service['photo'];

    if (!empty($category) && !empty($title)) {
        $photoName = $oldPhoto;

        if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            // Delete old photo
            if (file_exists("uploads/" . $oldPhoto)) {
                unlink("uploads/" . $oldPhoto);
            }

            // Upload new photo
            $uploadDir = 'uploads/';
            $photoName = time() . '_' . basename($_FILES['photo']['name']);
            $targetFile = $uploadDir . $photoName;
            move_uploaded_file($_FILES['photo']['tmp_name'], $targetFile);
        }

        // Update DB
        $stmt = $conn->prepare("UPDATE services SET category = ?, title = ?, photo = ? WHERE id = ?");
        $stmt->bind_param("sssi", $category, $title, $photoName, $id);
        $stmt->execute();

        header("Location: add-services.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Service</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .edit-container {
            max-width: 500px;
            margin: 60px auto;
            background-color: #fff;
            padding: 2.5rem;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.05);
        }
        .photo-thumb {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border-radius: 8px;
        }
    </style>
</head>
<body>
    
     <center>
        <a href="index.php">
            <img src="kingswell-logo.jpeg" style="width: 100px;" class="img-fluid">
        </a>
    </center>

<div class="container">
    <div class="edit-container">
        <h4 class="mb-4">Edit Service</h4>
        <form method="POST" enctype="multipart/form-data">
            <div class="mb-3">
                <label class="form-label">Category</label>
                <input type="text" name="category" class="form-control" value="<?php echo htmlspecialchars($service['category']); ?>" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Title</label>
                <input type="text" name="title" class="form-control" value="<?php echo htmlspecialchars($service['title']); ?>" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Current Photo</label><br>
                <img src="uploads/<?php echo $service['photo']; ?>" class="photo-thumb">
            </div>
            <div class="mb-3">
                <label class="form-label">Change Photo (optional)</label>
                <input type="file" name="photo" class="form-control" accept="image/*">
            </div>
            <button type="submit" name="update" class="btn btn-success w-100">Update Service</button>
            <a href="add-services.php" class="btn btn-secondary w-100 mt-2">Cancel</a>
        </form>
    </div>
</div>

</body>
</html>
