<?php
session_start();
include('connection.php'); // $conn must be defined

// Handle Add
if (isset($_POST['submit'])) {
    $category = trim($_POST['category']);
    $title = trim($_POST['title']);
    $photo = $_FILES['photo'];

    if (!empty($category) && !empty($title) && $photo['error'] == 0) {
        $uploadDir = 'uploads/';
        $fileName = time() . '_' . basename($photo['name']);
        $targetFile = $uploadDir . $fileName;
        move_uploaded_file($photo['tmp_name'], $targetFile);

        $stmt = $conn->prepare("INSERT INTO services (category, title, photo) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $category, $title, $fileName);
        $stmt->execute();
    }
}

// Handle Delete
if (isset($_GET['delete'])) {
    $id = (int) $_GET['delete'];
    $get = $conn->query("SELECT photo FROM services WHERE id = $id")->fetch_assoc();
    if ($get) {
        unlink("uploads/" . $get['photo']);
        $conn->query("DELETE FROM services WHERE id = $id");
    }
    header("Location: add-services.php");
    exit();
}

// Get all services
$services = $conn->query("SELECT * FROM services ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add Services</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .form-section {
            background-color: #fff;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
            margin-bottom: 30px;
        }
        .photo-thumb {
            width: 50px;
            height: 50px;
            object-fit: cover;
            border-radius: 5px;
        }
        @media (min-width: 768px) {
            .flex-md {
                display: flex;
                gap: 30px;
            }
            .form-section, .list-section {
                flex: 1;
            }
        }
    </style>
</head>
<body class="bg-light">
    
    <center>
        <a href="index.php">
            <img src="kingswell-logo.jpeg" style="width: 100px;" class="img-fluid">
        </a>
    </center>

<div class="container py-5">
    <h3 class="mb-4">Admin - Add Services</h3>

    <div class="flex-md">
        <!-- Form Section -->
        <div class="form-section">
            <form method="POST" enctype="multipart/form-data">
                <div class="mb-3">
                    <label class="form-label">Category</label>
                    <select name="category" class="form-control">
                        <option value="Aluminium Roofing">Aluminium Roofing</option>
                        <option value="Windows & Doors">Windows & Doors</option>
                        <option value="Glass Works">Glass Works</option>
                        <option value="Aluminium Panels">Aluminium Panels</option>
                        <option value="Stainless Works">Stainless Works</option>
                        <option value="Building Construction">Building Construction</option>
                        
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Title</label>
                    <input type="text" name="title" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Photo</label>
                    <input type="file" name="photo" class="form-control" accept="image/*" required>
                </div>
                <button type="submit" name="submit" class="btn btn-primary w-100">Upload Service</button>
            </form>
        </div>

        <!-- List Section -->
        <div class="list-section mt-5 mt-md-0">
            <div class="table-responsive">
                <table class="table table-bordered bg-white">
                    <thead class="table-light">
                        <tr>
                            <th>Photo</th>
                            <th>Category</th>
                            <th>Title</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $services->fetch_assoc()): ?>
                            <tr>
                                <td><img src="uploads/<?php echo $row['photo']; ?>" class="photo-thumb"></td>
                                <td><?php echo htmlspecialchars($row['category']); ?></td>
                                <td><?php echo htmlspecialchars($row['title']); ?></td>
                                <td>
                                    <a href="edit-service.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                                    <a href="add-services.php?delete=<?php echo $row['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this service?')">Delete</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                        <?php if ($services->num_rows == 0): ?>
                            <tr><td colspan="4" class="text-center">No services uploaded yet.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

</body>
</html>
