<?php
include("site-details.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Medical Excellence</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <style>
    body {
      font-family: 'Arial', sans-serif;
      background: linear-gradient(160deg, #0d47a1, #1e3c72);
      color: white;
    }

    /* ================= Navbar ================= */
    .navbar {
      transition: background 0.3s, padding 0.3s;
    }
    .navbar-brand img {
      transition: transform 0.3s;
    }
    .navbar-brand img:hover {
      transform: scale(1.1);
    }
    .nav-link {
      transition: color 0.3s;
    }
    .nav-link:hover {
      color: #34c759 !important;
    }

    /* ================= Hero Section ================= */
    .hero-section {
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      text-align: center;
      padding: 60px 20px;
    }
    .hero-content h1 {
      font-weight: 800;
      font-size: 2.5rem;
      line-height: 1.3;
      background: linear-gradient(90deg, #34c759, #a0ff99);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }
    .hero-content p {
      margin: 20px 0 30px;
      font-size: 1.2rem;
      color: #d0d0d0;
    }
    .btn-custom {
      background-color: #34c759;
      border: none;
      padding: 14px 30px;
      border-radius: 50px;
      font-size: 1.1rem;
      font-weight: 600;
      color: white;
      box-shadow: 0 6px 12px rgba(0,0,0,0.3);
      transition: all 0.3s ease-in-out;
    }
    .btn-custom:hover {
      background-color: #28a745;
      transform: translateY(-3px);
      box-shadow: 0 8px 16px rgba(0,0,0,0.4);
    }

    /* ================= Info Cards ================= */
    .info-section {
      background: #f8f9fa;
      color: #333;
      padding: 60px 20px;
    }
    .info-card {
      border: none;
      border-radius: 16px;
      box-shadow: 0 8px 25px rgba(0,0,0,0.1);
      padding: 40px 20px;
      transition: transform 0.3s, box-shadow 0.3s;
      background: white;
    }
    .info-card:hover {
      transform: translateY(-10px);
      box-shadow: 0 12px 30px rgba(0,0,0,0.2);
    }
    .info-icon {
      font-size: 3rem;
      color: #34c759;
      margin-bottom: 20px;
      display: inline-block;
      transition: transform 0.3s;
    }
    .info-card:hover .info-icon {
      transform: rotate(15deg) scale(1.2);
    }
    .info-card h5 {
      font-weight: 700;
      color: #0d47a1;
      margin-bottom: 15px;
    }
    .info-card p {
      color: #555;
      font-size: 1rem;
    }

    /* ================= Services Section ================= */
    .services-section {
      padding: 80px 20px;
    }
    .services-section h2 {
      font-weight: 800;
      margin-bottom: 15px;
    }
    .services-section p {
      color: #d0d0d0;
      margin-bottom: 50px;
    }
    .services-section .card {
      border-radius: 20px;
      transition: transform 0.3s, box-shadow 0.3s;
      cursor: pointer;
    }
    .services-section .card:hover {
      transform: translateY(-10px);
      box-shadow: 0 15px 35px rgba(0,0,0,0.2);
    }
    .services-section .card i {
      margin-bottom: 15px;
      font-size: 2.5rem;
    }

    /* ================= Team Section ================= */
    .team-section {
      padding: 80px 20px;
      background: #ffffff;
      color: #333;
    }
    .team-section h2 {
      margin-bottom: 15px;
    }
    .team-section p {
      color: #666;
      margin-bottom: 50px;
    }
    .team-section .card {
      border-radius: 20px;
      transition: transform 0.3s, box-shadow 0.3s;
    }
    .team-section .card:hover {
      transform: translateY(-8px);
      box-shadow: 0 12px 28px rgba(0,0,0,0.2);
    }
    .team-section .card img {
      border-top-left-radius: 20px;
      border-top-right-radius: 20px;
      transition: transform 0.3s;
    }
    .team-section .card:hover img {
      transform: scale(1.05);
    }

    /* ================= About Section ================= */
    .about-section {
      padding: 80px 20px;
    }
    .about-section h2 {
      font-weight: 800;
      margin-bottom: 30px;
      color: white;
    }
    .about-section p {
      color: #f0f0f0;
      font-size: 1.1rem;
      margin-bottom: 25px;
    }
    .about-section ul li {
      margin-bottom: 15px;
      font-size: 1rem;
    }
    .about-section ul li i {
      margin-right: 10px;
    }

    /* ================= Contact Section ================= */
    #contact {
      padding: 80px 20px;
      background: #f8f9fa;
      color: #333;
    }
    #contact h2 {
      margin-bottom: 15px;
    }
    #contact p {
      margin-bottom: 50px;
    }

    /* ================= Footer ================= */
    footer {
      background: #0d47a1;
      color: white;
      padding: 60px 20px 20px;
    }
    footer a {
      color: white;
      text-decoration: none;
      transition: color 0.3s;
    }
    footer a:hover {
      color: #34c759;
    }
    footer hr {
      border-top: 1px solid rgba(255,255,255,0.2);
    }
  </style>
</head>
<body>

  <!-- Navbar -->
  <nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm">
    <div class="container">
      <a class="navbar-brand fw-bold" href="#">
        <img src="logo.png" alt="Logo" style="height:50px;">
      </a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
        aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
        <ul class="navbar-nav fw-semibold">
          <li class="nav-item"><a class="nav-link active" href="#home">Home</a></li>
          <li class="nav-item"><a class="nav-link" href="#services">Services</a></li>
          <li class="nav-item"><a class="nav-link" href="#team">Team</a></li>
          <li class="nav-item"><a class="nav-link" href="#about">About</a></li>
          <li class="nav-item"><a class="nav-link" href="specialties.php">Specialties</a></li>
          <li class="nav-item"><a class="nav-link" href="contact.php">Contact</a></li>
        </ul>
      </div>
    </div>
  </nav>

<!-- Hero with Background Image Slider -->
<section class="hero-section p-0">
  <div id="heroCarousel" class="carousel slide carousel-fade" data-bs-ride="carousel" data-bs-interval="5000">
    <div class="carousel-inner">

      <!-- Slide 1 -->
      <div class="carousel-item active">
        <div class="hero-slide" style="background-image: url('https://cdn.pixabay.com/photo/2020/11/03/15/31/doctor-5710152_640.jpg');">
          <div class="overlay"></div>
          <div class="container text-center hero-content">
            <h1>Medical Excellence<br><span>with Human Compassion</span></h1>
            <p>For over 50 years, patients have trusted Otto Hans Medical Center for high-quality medical care and compassionate treatment.</p>
            <a href="#appointment" class="btn btn-custom">Schedule Appointment</a>
          </div>
        </div>
      </div>

      <!-- Slide 2 -->
      <div class="carousel-item">
        <div class="hero-slide" style="background-image: url('https://t3.ftcdn.net/jpg/05/04/25/70/360_F_504257032_jBtwqNdvdMN9Xm6aDT0hcvtxDXPZErrn.jpg');">
          <div class="overlay"></div>
          <div class="container text-center hero-content">
            <h1>Advanced Healthcare<br><span>for Every Generation</span></h1>
            <p>State-of-the-art technology and a team of dedicated professionals delivering exceptional care around the clock.</p>
            <a href="#services" class="btn btn-custom">Explore Services</a>
          </div>
        </div>
      </div>

      <!-- Slide 3 -->
      <div class="carousel-item">
        <div class="hero-slide" style="background-image: url('https://cdn.pixabay.com/photo/2017/05/26/15/06/doctor-2346235_640.jpg');">
          <div class="overlay"></div>
          <div class="container text-center hero-content">
            <h1>Trusted Doctors<br><span>Dedicated to You</span></h1>
            <p>Your health is our priority. Experience compassionate treatment tailored to your needs.</p>
            <a href="#team" class="btn btn-custom">Meet Our Team</a>
          </div>
        </div>
      </div>

    </div>

    <!-- Controls -->
    <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
      <span class="carousel-control-prev-icon"></span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
      <span class="carousel-control-next-icon"></span>
    </button>

    <!-- Indicators -->
    <div class="carousel-indicators">
      <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="0" class="active"></button>
      <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="1"></button>
      <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="2"></button>
    </div>
  </div>
</section>

<style>
  .hero-section {
    position: relative;
    height: 100vh;
    overflow: hidden;
  }
  .hero-slide {
    height: 100vh;
    background-size: cover;
    background-position: center;
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
  }
  .hero-slide .overlay {
    position: absolute;
    top: 0; left: 0; right: 0; bottom: 0;
    background: rgba(0, 0, 0, 0.55);
    z-index: 1;
  }
  .hero-content {
    position: relative;
    z-index: 2;
    max-width: 800px;
  }
  .hero-content h1 {
    font-weight: 800;
    font-size: 3rem;
    line-height: 1.3;
    background: linear-gradient(90deg, #34c759, #a0ff99);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
  }
  .hero-content p {
    margin: 20px 0 30px;
    font-size: 1.25rem;
    color: #f0f0f0;
  }
  .btn-custom {
    background-color: #34c759;
    border: none;
    padding: 14px 30px;
    border-radius: 50px;
    font-size: 1.1rem;
    font-weight: 600;
    color: white;
    box-shadow: 0 6px 12px rgba(0,0,0,0.3);
    transition: all 0.3s ease-in-out;
  }
  .btn-custom:hover {
    background-color: #28a745;
    transform: translateY(-3px);
    box-shadow: 0 8px 16px rgba(0,0,0,0.4);
  }
  /* Carousel controls */
  .carousel-control-prev-icon,
  .carousel-control-next-icon {
    background-size: 60% 60%;
  }
</style>


  <!-- Info Cards -->
  <section class="info-section">
    <div class="container">
      <div class="row text-center">
        <div class="col-md-4 mb-4">
          <div class="info-card">
            <div class="info-icon">🕒</div>
            <h5>Opening Hours</h5>
            <p>Mon - Fri: 7:00 - 20:00<br>Sat: 8:00 - 16:00<br>Sun: Emergency Only</p>
          </div>
        </div>
        <div class="col-md-4 mb-4">
          <div class="info-card">
            <div class="info-icon">⚕️</div>
            <h5>Specialties</h5>
            <p>Cardiology, Pediatrics, Orthopedics,<br>Neurology & more</p>
          </div>
        </div>
        <div class="col-md-4 mb-4">
          <div class="info-card">
            <div class="info-icon">🚑</div>
            <h5>Emergency</h5>
            <p>24/7 Emergency Services.<br>Call us anytime at <strong><?php echo $row["phone1"]; ?></strong></p>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Services, Team, About, Contact sections would continue here as in your original code with the same enhanced styling -->
  <a name="services"></a>
  <!-- Our Medical Services Section -->
<section class="services-section py-5">
  <div class="container">
    <div class="text-center mb-5">
      <h2 class="fw-bold">Our Medical Services</h2>
      <p style="color: white;">We provide a wide range of healthcare services to meet all your needs.</p>
    </div>

    <div class="row g-4">
      <!-- Card 1 -->
      <div class="col-md-4">
        <div class="card h-100 border-primary">
          <div class="card-body text-center">
            <div class="mb-3">
              <i class="fas fa-heartbeat fa-2x text-primary"></i>
            </div>
            <h5 class="card-title fw-bold">Cardiology</h5>
            <p class="card-text">Expert heart care and advanced treatments to keep your heart healthy.</p>
          </div>
        </div>
      </div>
      <!-- Card 2 -->
      <div class="col-md-4">
        <div class="card h-100 border-success">
          <div class="card-body text-center">
            <div class="mb-3">
              <i class="fas fa-user-md fa-2x text-success"></i>
            </div>
            <h5 class="card-title fw-bold">Pediatrics</h5>
            <p class="card-text">Comprehensive medical care for infants, children, and adolescents.</p>
          </div>
        </div>
      </div>
      <!-- Card 3 -->
      <div class="col-md-4">
        <div class="card h-100 border-danger">
          <div class="card-body text-center">
            <div class="mb-3">
              <i class="fas fa-ambulance fa-2x text-danger"></i>
            </div>
            <h5 class="card-title fw-bold">Emergency</h5>
            <p class="card-text">24/7 emergency services with quick response and dedicated specialists.</p>
          </div>
        </div>
      </div>
      <!-- Card 4 -->
      <div class="col-md-4">
        <div class="card h-100 border-warning">
          <div class="card-body text-center">
            <div class="mb-3">
              <i class="fas fa-x-ray fa-2x text-warning"></i>
            </div>
            <h5 class="card-title fw-bold">Radiology</h5>
            <p class="card-text">Advanced imaging and diagnostic services to detect and monitor conditions.</p>
          </div>
        </div>
      </div>
      <!-- Card 5 -->
      <div class="col-md-4">
        <div class="card h-100 border-info">
          <div class="card-body text-center">
            <div class="mb-3">
              <i class="fas fa-brain fa-2x text-info"></i>
            </div>
            <h5 class="card-title fw-bold">Neurology</h5>
            <p class="card-text">Specialized care for brain, spine, and nervous system disorders.</p>
          </div>
        </div>
      </div>
      <!-- Card 6 -->
      <div class="col-md-4">
        <div class="card h-100 border-dark">
          <div class="card-body text-center">
            <div class="mb-3">
              <i class="fas fa-stethoscope fa-2x text-dark"></i>
            </div>
            <h5 class="card-title fw-bold">General Medicine</h5>
            <p class="card-text">Comprehensive primary healthcare for patients of all ages.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<a name="team"></a>
<?php
include("connection.php");

// Fetch doctors from database
$sql = "SELECT * FROM doctors ORDER BY created_at DESC";
$result = mysqli_query($conn, $sql);
?>

<!-- Our Medical Team Section -->
<section class="team-section py-5 bg-white">
  <div class="container">
    <div class="text-center mb-5">
      <h2 class="fw-bold" style="color: black !important;">Our Medical Team</h2>
      <p class="text-muted">Meet our experienced doctors who are dedicated to providing excellent care.</p>
    </div>

    <div class="row g-4">
      <?php while ($doctor = mysqli_fetch_assoc($result)) { ?>
        <div class="col-md-4">
          <div class="card h-100 border-0 shadow-sm">
            <img src="<?php echo htmlspecialchars($doctor['photo']); ?>" class="card-img-top" alt="<?php echo htmlspecialchars($doctor['name']); ?>">
            <div class="card-body text-center">
              <h5 class="card-title fw-bold"><?php echo htmlspecialchars($doctor['name']); ?></h5>
              <p class="text-muted mb-1"><?php echo htmlspecialchars($doctor['position']); ?></p>
              <p class="small text-secondary mb-1"><strong>Experience:</strong> <?php echo htmlspecialchars($doctor['experience']); ?> years</p>
              <p class="small text-secondary"><strong>University:</strong> <?php echo htmlspecialchars($doctor['university']); ?></p>
              <div>
                <a href="#" class="text-primary me-3"><i class="fab fa-facebook"></i></a>
                <a href="#" class="text-info me-3"><i class="fab fa-twitter"></i></a>
                <a href="#" class="text-danger"><i class="fab fa-linkedin"></i></a>
              </div>
            </div>
          </div>
        </div>
      <?php } ?>
    </div>
  </div>
</section>

<a name="about"></a>
<!-- About Us Section -->
<section class="about-section py-5 bg-light" style="background: linear-gradient(160deg, #0d47a1, #1e3c72);">
  <div class="container">
    <div class="row align-items-center g-5">
      
      <!-- Left Image -->
      <div class="col-lg-6">
        <img src="https://cdn.pixabay.com/photo/2017/05/26/15/06/doctor-2346235_640.jpg" alt="About Us" class="img-fluid rounded shadow">
      </div>

      <!-- Right Content -->
      <div class="col-lg-6">
        <h2 class="fw-bold mb-4">About Our Medical Center</h2>
        <p class="mb-4">
          For over 50 years, Otto Hans Medical Center has been a trusted name in healthcare. 
          Our mission is to combine medical excellence with human compassion, ensuring that every 
          patient receives the highest quality of care.
        </p>
        
        <ul class="list-unstyled mb-4">
          <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i> Experienced and dedicated medical professionals</li>
          <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i> State-of-the-art diagnostic and treatment facilities</li>
          <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i> Patient-centered approach with personalized care</li>
          <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i> 24/7 emergency services available</li>
        </ul>

      </div>
    </div>
  </div>
</section>

<!-- ================= Contact Us Section ================= -->
<section id="contact" class="py-5" style="background-color: #f8f9fa;">
  <div class="container">
    <div class="text-center mb-5">
      <h2 class="fw-bold" style="color: black;">Contact Us</h2>
      <p class="text-muted">We are here to assist you. Reach out or schedule an appointment.</p>
    </div>
    
    <div class="row">
      <!-- Contact Form -->
      <div class="col-lg-12 mb-4">
        <div class="card shadow-sm border-0">
          <div class="card-body p-4">
            <h5 class="mb-4 fw-bold">Schedule an Appointment</h5>
           <?php
// Check if the form was submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect and sanitize input
    $name = htmlspecialchars(trim($_POST['name']));
    $email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
    $phone = htmlspecialchars(trim($_POST['phone']));
    $service = htmlspecialchars(trim($_POST['service']));
    $date = htmlspecialchars(trim($_POST['date']));
    $message = htmlspecialchars(trim($_POST['message']));

    // Recipient email
    $to = "noreply@1strivaincoinc.online"; // <-- Replace with your email
    $subject = "New Appointment Request from $name";

    // Email body
    $body = "You have received a new appointment request:\n\n";
    $body .= "Full Name: $name\n";
    $body .= "Email: $email\n";
    $body .= "Phone: $phone\n";
    $body .= "Service: $service\n";
    $body .= "Preferred Date: $date\n";
    $body .= "Message:\n$message\n";

    // Email headers
    $headers = "From: $email\r\n";
    $headers .= "Reply-To: $email\r\n";

    // Send email
    if (mail($to, $subject, $body, $headers)) {
        $success = "Your appointment request has been sent successfully!";
    } else {
        $error = "Sorry, something went wrong. Please try again later.";
    }
}
?>
<a name="appointment"></a>
<!-- HTML Form -->
<form method="post" action="">
    <?php if (!empty($success)) echo "<div class='alert alert-success'>$success</div>"; ?>
    <?php if (!empty($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>

    <div class="mb-3">
        <label for="name" class="form-label">Full Name</label>
        <input type="text" class="form-control" id="name" name="name" placeholder="John Doe" required>
    </div>
    <div class="mb-3">
        <label for="email" class="form-label">Email Address</label>
        <input type="email" class="form-control" id="email" name="email" placeholder="john@example.com" required>
    </div>
    <div class="mb-3">
        <label for="phone" class="form-label">Phone Number</label>
        <input type="tel" class="form-control" id="phone" name="phone" required>
    </div>
    <div class="mb-3">
        <label for="service" class="form-label">Service</label>
        <select class="form-select" id="service" name="service" required>
            <option selected disabled>Select a service</option>
            <option>Orthopedic</option>
            <option>Consultation</option>
            <option>Medical Checkup</option>
            <option>Follow-up Appointment</option>
            <option>Emergency</option>
        </select>
    </div>
    <div class="mb-3">
        <label for="date" class="form-label">Preferred Date</label>
        <input type="date" class="form-control" id="date" name="date" required>
    </div>
    <div class="mb-3">
        <label for="message" class="form-label">Message</label>
        <textarea class="form-control" id="message" name="message" rows="4" placeholder="Your message..."></textarea>
    </div>
    <button type="submit" class="btn btn-primary w-100">Book Appointment</button>
</form>

          </div>
        </div>
      </div>

     
      </div>
    </div>
  </div>
</section>

<!-- ================= Footer Section ================= -->
<footer class="bg-dark text-white pt-5 pb-4">
  <div class="container">
    <div class="row align-items-start">

      <!-- About / Logo -->
      <div class="col-md-4 mb-4 d-flex flex-column align-items-start">
        <div class="d-flex align-items-center mb-3">
          <img src="logo.png" alt="Ottohans Medical Center Logo" style="height:50px; margin-right:10px;">
          <h5 class="fw-bold mb-0">Ottohans Medical Center</h5>
        </div>
        <p>We provide top-notch healthcare services with professionalism, innovation, and compassion. Your health is our priority.</p>
      </div>

      <!-- Quick Links -->
      <div class="col-md-2 mb-4">
        <h5 class="fw-bold mb-3">Quick Links</h5>
        <ul class="list-unstyled">
          <li><a href="index.php#home" class="text-white text-decoration-none">Home</a></li>
          <li><a href="index.php#services" class="text-white text-decoration-none">Services</a></li>
          <li><a href="index.php#team" class="text-white text-decoration-none">Team</a></li>
          <li><a href="index.php#about" class="text-white text-decoration-none">About</a></li>
          <li><a href="specialties.php" class="text-white text-decoration-none">Specialties</a></li>
          <li><a href="contact.php" class="text-white text-decoration-none">Contact</a></li>
        </ul>
      </div>

      <!-- Contact Info -->
      <div class="col-md-3 mb-4">
        <h5 class="fw-bold mb-3">Contact Us</h5>
        <p class="mb-2"><i class="bi bi-geo-alt-fill me-2"></i><?php echo $row["address1"]; ?></p>

        <p class="mb-2"><i class="bi bi-geo-alt-fill me-2"></i><?php echo $row["address2"]; ?></p>

        <p class="mb-2"><i class="bi bi-telephone-fill me-2"></i><?php echo $row["phone1"]; ?></p>
        <p class="mb-2"><i class="bi bi-telephone-fill me-2"></i><?php echo $row["phone2"]; ?></p>
        <p class="mb-2"><i class="bi bi-envelope-fill me-2"></i><?php echo $row["email1"]; ?></p>
      </div>

      <!-- Social Media -->
      <div class="col-md-3 mb-4">
        <h5 class="fw-bold mb-3">Follow Us</h5>
        <div class="d-flex gap-3 fs-4">
          <a href="#" class="text-white"><i class="bi bi-facebook"></i></a>
          <a href="#" class="text-white"><i class="bi bi-twitter"></i></a>
          <a href="#" class="text-white"><i class="bi bi-linkedin"></i></a>
          <a href="#" class="text-white"><i class="bi bi-instagram"></i></a>
        </div>
      </div>
    </div>

    <hr class="bg-light">

    <!-- Copyright -->
    <div class="text-center pt-3">
      <p class="mb-0">&copy; 2025 Ottohans Medical Center. All Rights Reserved.</p>
    </div>
  </div>
</footer>

<!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '65d0d39bd9c01850ac614410835da1864214e5ef';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>


<!-- ================= Bootstrap Icons CDN ================= -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">


<!-- ================= Bootstrap Icons CDN ================= -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">


<!-- Font Awesome (for icons) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">


  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>