
<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>
    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="<?php echo e(route('cancelconfirm')); ?>" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Transaction Preview
        </div>
        <div class="right">
            <a onclick="location.reload();" class="headerButton">
                <ion-icon name="refresh"></ion-icon>
            </a>
        </div>
    </div>
    <!-- * App Header -->



    <!-- App Capsule -->
    <div id="appCapsule" class="full-height">

        <div class="section mt-2 mb-2">


            <div class="listed-detail mt-3">
                <div class="icon-wrapper">
                    <div class="iconbox">
                        <ion-icon name="eye"></ion-icon>
                    </div>
                </div>
                <h3 class="text-center mt-2">Preview Transaction</h3>
            </div>

            <ul class="listview flush transparent simple-listview no-space mt-3">
                <li>
                    <strong>To</strong>
                    <span><?php echo e($confirmdata['accountname']); ?></span>
                </li>
                <li>
                    <strong>Transaction type</strong>
                    <span><?php echo e($confirmdata['payment_mode']); ?></span>
                </li>
                <?php if($confirmdata['payment_mode'] == 'Wire Transfer'): ?>
                    <li>
                        <strong>Account Number</strong>
                        <span><?php echo e($confirmdata['accountnumber']); ?></span>
                    </li>
                <?php elseif($confirmdata['payment_mode'] == 'Cryptocurrency'): ?>
                    <li>
                        <strong>Wallet Address</strong>
                        <span><?php echo e($confirmdata['accountnumber']); ?></span>
                    </li>
                <?php elseif($confirmdata['payment_mode'] == 'Western Union'): ?>
                    <li>
                        <strong>Name</strong>
                        <span><?php echo e($confirmdata['accountnumber']); ?></span>
                    </li>
                <?php else: ?>
                    <li>
                        <strong>Email</strong>
                        <span><?php echo e($confirmdata['accountnumber']); ?></span>
                    </li>
                <?php endif; ?>
                <?php if($confirmdata['payment_mode'] == 'Wire Transfer'): ?>
                    <li>
                        <strong>Routine Number</strong>
                        <span><?php echo e($confirmdata['iban']); ?></span>
                    </li>
                <?php endif; ?>
                <li>
                    <strong>Amount</strong>
                    <h3 class="m-0">
                        <?php echo e(number_format($confirmdata['amount'], 2, '.', ',')); ?><?php echo e(Auth::user()->currency); ?>

                    </h3>
                </li>

                <li>
                    <strong>Refrence ID</strong>
                    <span>#<?php echo e($confirmdata['txn_id']); ?></span>
                </li>
            </ul>


            <br>
            <div class="form-group basic">
                <div class="row">
                    <div class="col-6">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#DialogBasic"
                            class="btn btn-lg btn-danger cancel btn-block">Cancel</a>
                    </div>
                    <div class="col-6">



                        <a class="btn btn-lg btn-primary btn-block" href='<?php echo e(route('proceedtranscation')); ?>'
                            name="inter-preview">Proceed</a>



                    </div>
                </div>
            </div>



        </div>

    </div>
    <!-- * App Capsule -->


    <!-- Dialog Basic -->
    <div class="modal fade dialogbox" id="DialogBasic" data-bs-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Cancel Transaction</h5>
                </div>
                <div class="modal-body">
                    Are you sure?
                </div>
                <div class="modal-footer">
                    <div class="btn-inline">
                        <a href="#" class="btn btn-text-secondary" data-bs-dismiss="modal">CLOSE</a>
                        <a href="<?php echo e(route('cancelconfirm')); ?>" class="btn btn-text-primary">YES</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- * Dialog Basic -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.bankapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/karamelh/public_html/ubs.karamelhub.com.ng/resources/views/user/confirm.blade.php ENDPATH**/ ?>