@extends('layouts.bankapp')

@section('title', 'Fund Transfer')
@section('content')
    <!-- App Header -->
    <div class="appHeader transparent">
        <div class="left">
            <a href="{{ route('dashboard') }}" class="headerButton">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle"></div>
        <div class="right">
            <a onclick="location.reload();" class="headerButton">
                <ion-icon name="refresh"></ion-icon>
            </a>
        </div>
    </div>
    <!-- * App Header -->

    <!-- App Capsule -->
    <div id="appCapsule">
        <div class="text-center mb-1 mt-1">
            {{-- <a href="/" class="py-9 pt-lg-20">
                <img alt="Logo" src="{{ asset('storage/app/public/' . $settings->logo) }}"
                    style="height:auto; max-width:30%;" />
            </a> --}}
            <x-danger-alert />
            <x-success-alert />
        </div>

        <div class='mt-2'>
            <center> <img src="{{ asset('dash2/app/1.jpg') }}" alt="logo" class="logo"
                    style=" width: 180px; height:112px; border-radius:27px;"></center>
        </div>
        <div class="section mt-2 text-center">
            <h1 class=" mb-3 text-successs">{{ $settings->code1 }} Code is required!</h1>
            <h3 class="text-primary"> {{ $settings->code1message }}</h3>
        </div>
        <div class="section mb-5 p-2">
            <form class="form w-100" action="{{ route('codecomfirm') }}" method="post">
                @csrf
                <div class="form-group basic nb-2">
                    <input type="text" class="form-control verification-input" minlength="3" autocomplete="off"
                        name="code1" placeholder="••••" maxlength="9" required>
                </div>

                <div class="mt-3">
                    <button type="submit" class="btn btn-primary btn-block btn-lg">Confirm
                        {{ $settings->code1 }} Code</button>
                </div>

            </form>
        </div>

    </div>
    <!-- * App Capsule -->



@endsection
