<?php
session_start();
include "header.php";
include "../config.php"; // adjust path

if (!isset($_SESSION['USERLOGIN'])) {
    header("Location: login.php");
    exit();
}

$msg = "";
$err = "";

if (isset($_POST['trade'])) {
    $asset  = mysqli_real_escape_string($link, $_POST['asset']);
    $amount = floatval($_POST['amount']);

    if ($amount > 0) {
        $sql = "INSERT INTO trades (user_id, asset, amount, status) 
                VALUES ('$uid', '$asset', '$amount', 'open')";
        if (mysqli_query($link, $sql)) {
            $msg = "Trade placed successfully!";
        } else {
            $err = mysqli_error($link);
        }
    } else {
        $err = "Enter a valid amount.";
    }
}
?>

<div class="page-content">
    <div class="container-fluid">
        <?php 
        if ($msg != "") echo customAlert("success", $msg);
        if ($err != "") echo customAlert("error", $err);
        ?>

        <div class="row">
            <div class="col-lg-8 offset-lg-2">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Trading Dashboard</h4>
                    </div>
                    <div class="card-body">
                        <form method="post" action="">
                            <div class="mb-3">
                                <label class="form-label">Select Asset</label>
                                <select class="form-control" name="asset" required>
                                    <option value="BTC">Bitcoin (BTC)</option>
                                    <option value="ETH">Ethereum (ETH)</option>
                                    <option value="Forex">Forex</option>
                                    <option value="Gold">Gold</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Amount ($)</label>
                                <input type="number" step="0.01" min="1" class="form-control" name="amount" required>
                            </div>

                            <button type="submit" name="trade" class="btn btn-primary">Place Trade</button>
                        </form>
                    </div>
                </div>

        <!-- User's active trades -->
        <div class="row mt-5">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">My Active Trades</h4>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Asset</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Profit/Loss</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                            $res = mysqli_query($link, "SELECT * FROM trades WHERE user_id='$uid' ORDER BY id DESC");
                            if (mysqli_num_rows($res) > 0) {
                                while ($row = mysqli_fetch_assoc($res)) {
                                    echo "<tr>
                                        <td>{$row['id']}</td>
                                        <td>{$row['asset']}</td>
                                        <td>\${$row['amount']}</td>
                                        <td>{$row['status']}</td>
                                        <td>\${$row['profit_loss']}</td>
                                        <td>{$row['created_at']}</td>
                                    </tr>";
                                }
                            } else {
                                echo "<tr><td colspan='6' class='text-center'>No trades yet</td></tr>";
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php include "footer.php"; ?>
