<?php
include("connection.php");

// Get post ID from URL
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
  header("Location: index.php");
  exit();
}

$post_id = (int) $_GET['id'];

// Fetch the post
$stmt = $conn->prepare("SELECT * FROM posts WHERE id = ?");
$stmt->bind_param("i", $post_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
  echo "Post not found.";
  exit();
}

$post = $result->fetch_assoc();

// Fetch recent posts (exclude current post)
$recentStmt = $conn->prepare("SELECT id, title, thumbnail, created_at FROM posts WHERE id != ? ORDER BY created_at DESC LIMIT 5");
$recentStmt->bind_param("i", $post_id);
$recentStmt->execute();
$recentPosts = $recentStmt->get_result();
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title><?php echo htmlspecialchars($post['title']); ?> - Uncommon Learning Standard</title>
  <meta name="description" content="<?php echo substr(strip_tags($post['description']), 0, 150); ?>">
  <meta name="keywords" content="<?php echo htmlspecialchars($post['title']); ?>">

  <!-- Favicons -->
  <link href="logo.png" rel="icon">
  <link href="logo.png" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&family=EB+Garamond:ital,wght@0,400;0,500;0,600;0,700;0,800;1,400;1,500;1,600;1,700;1,800&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="assets/css/main.css" rel="stylesheet">

  <!-- Custom Fix -->
  <style>
    .blog-details .content {
      padding: 0 !important;
      margin-top: 10px;
      line-height: 1.7;
    }
    .sidebar .recent-posts img {
      width: 80px;
      height: 60px;
      object-fit: cover;
      margin-right: 10px;
      border-radius: 5px;
    }
    .sidebar .recent-posts .post-item {
      display: flex;
      align-items: center;
      margin-bottom: 15px;
    }
    .sidebar .recent-posts .post-item h4 {
      font-size: 15px;
      margin: 0;
    }
    .sidebar .recent-posts .post-item time {
      font-size: 13px;
      color: #888;
    }
  </style>
</head>

<body class="single-post-page">

 <?php include("header.php"); ?>

  <main class="main">

    <!-- Page Title -->
    <div class="page-title">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0"><?php echo htmlspecialchars($post['title']); ?></h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="index.php">Home</a></li>
            <li class="current">Single Post</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <div class="container">
      <div class="row">

        <!-- Main Content -->
        <div class="col-lg-8">
          <section id="blog-details" class="blog-details section">
            <div class="container">
              <article class="article">

                <div class="post-img">
                  <img src="admin/<?php echo htmlspecialchars($post['thumbnail']); ?>" style="width: 100%" alt="" class="img-fluid">
                </div>

                <h2 class="title"><?php echo htmlspecialchars($post['title']); ?></h2>

                <div class="meta-top">
                  <ul>
                    <li class="d-flex align-items-center"><i class="bi bi-clock"></i>
                      <time datetime="<?php echo date('Y-m-d', strtotime($post['created_at'])); ?>">
                        <?php echo date("M j, Y", strtotime($post['created_at'])); ?>
                      </time>
                    </li>
                  </ul>
                </div><!-- End meta top -->

                <div class="content">
                  <?php echo $post['description']; ?>
                </div><!-- End post content -->

              </article>
            </div>
          </section>
        </div><!-- End Main Content -->

        <!-- Sidebar -->
        <div class="col-lg-4">
          <div class="sidebar">

            <h3 class="sidebar-title">Recent Posts</h3>
            <div class="recent-posts">
              <?php while ($recent = $recentPosts->fetch_assoc()) { ?>
                <div class="post-item">
                  <a href="single-post.php?id=<?php echo $recent['id']; ?>">
                    <img src="admin/<?php echo htmlspecialchars($recent['thumbnail']); ?>" alt="">
                  </a>
                  <div>
                    <h4><a href="single-post.php?id=<?php echo $recent['id']; ?>"><?php echo htmlspecialchars($recent['title']); ?></a></h4>
                    <time datetime="<?php echo date('Y-m-d', strtotime($recent['created_at'])); ?>">
                      <?php echo date("M j, Y", strtotime($recent['created_at'])); ?>
                    </time>
                  </div>
                </div>
              <?php } ?>
            </div><!-- End recent posts -->

          </div>
        </div><!-- End Sidebar -->

      </div>
    </div>

  </main>

 <?php include("footer.php"); ?>
 
  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Preloader -->
  <div id="preloader"></div>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/vendor/aos/aos.js"></script>
  <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>

  <!-- Main JS File -->
  <script src="assets/js/main.js"></script>

</body>
</html>
