<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Privacy Policy - Uncommon Learning Standard</title>
  <meta name="description" content="Read the Privacy Policy of Uncommon Learning Standard (ULS). Learn how we collect, use, and protect your information.">
  <meta name="keywords" content="Privacy, Policy, ULS, Data Protection">

  <!-- Favicons -->
  <link href="logo.png" rel="icon">
  <link href="logo.png" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&family=EB+Garamond:wght@400;600;700&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="assets/css/main.css" rel="stylesheet">
</head>

<body class="privacy-page">

 <?php include("header.php"); ?>

  <main class="main">

    <!-- Page Title -->
    <div class="page-title">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0">Privacy Policy</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="index.php">Home</a></li>
            <li class="current">Privacy Policy</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- Privacy Section -->
    <section id="privacy" class="section py-5">
      <div class="container" data-aos="fade-up">
        <h2 class="fw-bold mb-4">Uncommon Learning Standard (“ULS,” “we,” “our,” or “us”) respects your privacy.</h2>
        <p class="lead mb-5">
          This Privacy Policy explains how we collect, use, and protect your information when you use our website.
        </p>

        <div class="privacy-content">
          <h4>1. Information We Collect</h4>
          <p><strong>Personal Information:</strong> If you contact us (e.g., through forms or email), we may collect your name and email address.</p>
          <p><strong>Non-Personal Information:</strong> We automatically collect general data such as IP address, browser type, device, and pages visited, for analytics and site improvement.</p>

          <h4 class="mt-4">2. How We Use Your Information</h4>
          <ul>
            <li>Respond to inquiries and messages.</li>
            <li>Improve site performance and user experience.</li>
            <li>Share updates, if you choose to subscribe.</li>
          </ul>

          <h4 class="mt-4">3. Sharing of Information</h4>
          <p>We do not sell, rent, or trade your personal information.</p>
          <p>We may share non-personal information with trusted third-party services (e.g., analytics tools) to improve our website.</p>

          <h4 class="mt-4">4. Cookies</h4>
          <p>Our site may use cookies to enhance your browsing experience. You can disable cookies in your browser settings, but some features may not work properly.</p>

          <h4 class="mt-4">5. Data Protection</h4>
          <p>We take reasonable steps to protect your personal data. However, no online system is 100% secure, and we cannot guarantee complete security.</p>

          <h4 class="mt-4">6. Third-Party Links</h4>
          <p>ULS may contain links to other websites. We are not responsible for the privacy practices of third-party sites.</p>

          <h4 class="mt-4">7. Children’s Privacy</h4>
          <p>Our site is intended for general audiences and does not knowingly collect information from children under 13.</p>

          <h4 class="mt-4">8. Changes to This Policy</h4>
          <p>We may update this Privacy Policy from time to time. Updates will be posted on this page with a new “Effective Date.”</p>

          <h4 class="mt-4">9. Contact Us</h4>
          <p>If you have any questions about this Privacy Policy, contact us at:</p>
          <p><strong>Email:</strong> <a href="mailto:uncommonlearningstandard@gmail.com">uncommonlearningstandard@gmail.com</a></p>
        </div>
      </div>
    </section>

    <!-- Call to Action -->
    <section class="section bg-primary text-white text-center py-5">
      <div class="container" data-aos="fade-up">
        <h2 class="fw-bold">Discover a World of Possibilities</h2>
        <p class="lead">Join thousands of readers exploring knowledge in a smarter way. Start learning today!</p>
        <a href="index.php" class="btn btn-light px-4 py-2 mt-3">Get Started</a>
      </div>
    </section>

  </main>

 <?php include("footer.php"); ?>

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
  </a>

  <!-- Preloader -->
  <div id="preloader"></div>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/vendor/aos/aos.js"></script>
  <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>

  <!-- Main JS File -->
  <script src="assets/js/main.js"></script>

</body>
</html>
