<?php
session_start();
include "../connection.php"; // DB connection

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: ../admin-login.php');
    exit();
}

// ✅ Fetch admin details
$admin_id = $_SESSION['admin_id']; 
$result = mysqli_query($conn, "SELECT * FROM admins WHERE id = $admin_id LIMIT 1");
$admin = mysqli_fetch_assoc($result);

if (!$admin) {
    echo "❌ Admin not found!";
    exit();
}

// ✅ Handle update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fullname = mysqli_real_escape_string($conn, $_POST['fullname']);
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = !empty($_POST['password']) ? mysqli_real_escape_string($conn, $_POST['password']) : null;

    $sql = "UPDATE admins SET fullname='$fullname', username='$username'";
    if ($password) {
        $sql .= ", password='$password'";
    }
    $sql .= " WHERE id=$admin_id";

    if (mysqli_query($conn, $sql)) {
        $msg = "✅ Profile updated successfully!";
        $result = mysqli_query($conn, "SELECT * FROM admins WHERE id = $admin_id LIMIT 1");
        $admin = mysqli_fetch_assoc($result);
    } else {
        $msg = "❌ Error updating profile: " . mysqli_error($conn);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Admin Profile</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f4f6f9;
    }
    .sidebar {
      background: linear-gradient(180deg, #0d6efd, #6610f2);
      min-height: 100vh;
      color: #fff;
    }
    .sidebar .nav-link {
      color: #ddd;
      border-radius: 8px;
      margin: 4px 0;
      padding: 10px 15px;
      transition: all 0.3s ease;
    }
    .sidebar .nav-link:hover,
    .sidebar .nav-link.active {
      background: rgba(255, 255, 255, 0.2);
      color: #fff;
    }
    .navbar {
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    .card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    }
  </style>
</head>
<body>

<!-- Top Navbar (for mobile toggle) -->
<nav class="navbar navbar-expand-lg navbar-light bg-white sticky-top d-lg-none">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold text-primary" href="#">Blog Admin</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar">
      <span class="navbar-toggler-icon"></span>
    </button>
  </div>
</nav>

<div class="container-fluid">
  <div class="row">

    <?php include("sidebar.php"); ?>

    <!-- Main Content -->
    <main class="col-lg-10 ms-auto px-4 py-4">
      <h2 class="mb-4 text-primary"><i class="fa fa-user-circle"></i> Admin Profile</h2>

      <?php if (!empty($msg)): ?>
        <div class="alert alert-info"><?= $msg; ?></div>
      <?php endif; ?>

      <div class="card p-4">
        <form method="POST">
          <div class="mb-3">
            <label class="form-label fw-bold">Full Name</label>
            <input type="text" name="fullname" class="form-control" value="<?= htmlspecialchars($admin['fullname']); ?>" required>
          </div>

          <div class="mb-3">
            <label class="form-label fw-bold">Username</label>
            <input type="text" name="username" class="form-control" value="<?= htmlspecialchars($admin['username']); ?>" required>
          </div>

          <div class="mb-3">
            <label class="form-label fw-bold">Password (leave blank to keep current)</label>
            <input type="password" name="password" class="form-control">
          </div>

          <button type="submit" class="btn btn-success px-4">Update Profile</button>
          <a href="index.php" class="btn btn-secondary px-4">Cancel</a>
        </form>
      </div>
    </main>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
