<?php
// new-post.php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include "../connection.php"; // DB connection ($conn)

// ✅ Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);

    // Handle thumbnail upload
    $thumbnail = null;
    if (!empty($_FILES['thumbnail']['name'])) {
        $uploadDir = "uploads/";
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        $thumbnail = $uploadDir . time() . "_" . basename($_FILES['thumbnail']['name']);
        move_uploaded_file($_FILES['thumbnail']['tmp_name'], $thumbnail);
    }

    // Insert into DB
    $sql = "INSERT INTO posts (title, thumbnail, description, created_at) 
            VALUES ('$title', '$thumbnail', '$description', NOW())";
    if (mysqli_query($conn, $sql)) {
        $msg = "✅ New post created successfully!";
    } else {
        $msg = "❌ Error: " . mysqli_error($conn);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Blog Admin Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>

  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f4f6f9;
    }
    .sidebar {
      background: linear-gradient(180deg, #0d6efd, #6610f2);
      min-height: 100vh;
      color: #fff;
    }
    .sidebar .nav-link {
      color: #ddd;
      border-radius: 8px;
      margin: 4px 0;
      padding: 10px 15px;
      transition: all 0.3s ease;
    }
    .sidebar .nav-link:hover,
    .sidebar .nav-link.active {
      background: rgba(255, 255, 255, 0.2);
      color: #fff;
    }
    .card {
      border: none;
      border-radius: 16px;
      transition: all 0.3s ease;
    }
    .card-hover:hover {
      transform: translateY(-6px);
      box-shadow: 0 12px 25px rgba(0,0,0,0.15);
    }
    .navbar {
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
  </style>
</head>
<body>

<!-- Top Navbar (for mobile toggle) -->
<nav class="navbar navbar-expand-lg navbar-light bg-white sticky-top d-lg-none">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold text-primary" href="#">Blog Admin</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar">
      <span class="navbar-toggler-icon"></span>
    </button>
  </div>
</nav>

<div class="container-fluid">
  <div class="row">
    
    <?php include("sidebar.php"); ?>

    <!-- Main Content -->
    <main class="col-lg-10 ms-auto px-4 py-4" style="background-color: white;">
<h2 class="mb-4 text-primary">✍️ Create New Blog Post</h2>

       <?php if (!empty($msg)): ?>
      <div class="alert alert-info"><?= $msg; ?></div>
    <?php endif; ?>
    
      <div class="row g-4">
        
         <form action="" method="POST" enctype="multipart/form-data">
      <div class="mb-3">
        <label class="form-label fw-bold">Title</label>
        <input type="text" name="title" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label fw-bold">Thumbnail</label>
        <input type="file" name="thumbnail" class="form-control" accept="image/*">
      </div>

      <div class="mb-3">
        <label class="form-label fw-bold">Description</label>
        <textarea name="description" class="form-control" rows="6"></textarea>
        <script>
          CKEDITOR.replace('description');
        </script>
      </div>

      <button type="submit" class="btn btn-success px-4">Publish</button>
      <a href="index.php" class="btn btn-secondary px-4">Cancel</a>
    </form>
       
       
      </div>
    </main>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
