<?php
// edit-post.php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include "../connection.php"; // DB connection ($conn)

// ✅ Check if ID exists
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: manage-posts.php");
    exit;
}

$id = intval($_GET['id']);
$post = mysqli_query($conn, "SELECT * FROM posts WHERE id = $id");
if (mysqli_num_rows($post) === 0) {
    echo "❌ Post not found!";
    exit;
}
$postData = mysqli_fetch_assoc($post);

// ✅ Handle update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);

    $thumbnail = $postData['thumbnail'];
    if (!empty($_FILES['thumbnail']['name'])) {
        $uploadDir = "uploads/";
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        $thumbnail = $uploadDir . time() . "_" . basename($_FILES['thumbnail']['name']);
        move_uploaded_file($_FILES['thumbnail']['tmp_name'], $thumbnail);
    }

    $sql = "UPDATE posts 
            SET title = '$title', thumbnail = '$thumbnail', description = '$description' 
            WHERE id = $id";
    if (mysqli_query($conn, $sql)) {
        header("Location: manage-posts.php?msg=updated");
        exit;
    } else {
        $msg = "❌ Error updating post: " . mysqli_error($conn);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit Post</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>
</head>
<body class="bg-light">

<div class="container py-5">
  <div class="card shadow-lg p-4">
    <h2 class="mb-4 text-primary">✏️ Edit Blog Post</h2>

    <?php if (!empty($msg)): ?>
      <div class="alert alert-danger"><?= $msg; ?></div>
    <?php endif; ?>

    <form action="" method="POST" enctype="multipart/form-data">
      <div class="mb-3">
        <label class="form-label fw-bold">Title</label>
        <input type="text" name="title" class="form-control" value="<?= htmlspecialchars($postData['title']); ?>" required>
      </div>

      <div class="mb-3">
        <label class="form-label fw-bold">Current Thumbnail</label><br>
        <?php if ($postData['thumbnail']): ?>
          <img src="<?= $postData['thumbnail']; ?>" alt="Thumbnail" class="img-thumbnail mb-2" style="max-width: 200px;">
        <?php else: ?>
          <p class="text-muted">No thumbnail uploaded</p>
        <?php endif; ?>
        <input type="file" name="thumbnail" class="form-control" accept="image/*">
      </div>

      <div class="mb-3">
        <label class="form-label fw-bold">Description</label>
        <textarea name="description" class="form-control" rows="6"><?= htmlspecialchars($postData['description']); ?></textarea>
        <script>
          CKEDITOR.replace('description');
        </script>
      </div>

      <button type="submit" class="btn btn-success px-4">Update</button>
      <a href="manage-posts.php" class="btn btn-secondary px-4">Cancel</a>
    </form>
  </div>
</div>

</body>
</html>
