<?php
// admin_login.php
// Includes a database connection file named 'connection.php' which must define $conn (mysqli)
// NOTE: Passwords are compared in plain text as requested. THIS IS INSECURE for production.

session_start();
require_once 'connection.php'; // must set $conn (mysqli)

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = isset($_POST['username']) ? trim($_POST['username']) : '';
    $password = isset($_POST['password']) ? trim($_POST['password']) : '';

    if ($username === '' || $password === '') {
        $errors[] = 'Please enter your username and password.';
    } else {
        // Use prepared statements to avoid SQL injection even though passwords are plain text.
        $sql = "SELECT id, username, password, fullname FROM admins WHERE username = ? LIMIT 1";
        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param('s', $username);
            $stmt->execute();
            $res = $stmt->get_result();
            if ($row = $res->fetch_assoc()) {
                // Plain-text comparison (explicitly requested)
                if ($password === $row['password']) {
                    // Success
                    $_SESSION['admin_logged_in'] = true;
                    $_SESSION['admin_id'] = $row['id'];
                    $_SESSION['admin_user'] = $row['username'];
                    $_SESSION['admin_name'] = $row['fullname'] ?? $row['username'];

                    // Regenerate session id for some session safety
                    session_regenerate_id(true);

                    header('Location: admin/index.php');
                    exit;
                } else {
                    $errors[] = 'Invalid username or password.';
                }
            } else {
                $errors[] = 'Invalid username or password.';
            }
            $stmt->close();
        } else {
            $errors[] = 'Database error: could not prepare statement.';
        }
    }
}
?>

<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin Login — Portal</title>
  <style>
    :root{
      --bg1: #0f172a;
      --glass: rgba(255,255,255,0.06);
      --accent: #7c3aed;
      --accent2: #06b6d4;
      --card-grad: linear-gradient(135deg, rgba(255,255,255,0.03), rgba(255,255,255,0.01));
    }
    *{box-sizing:border-box;font-family:Inter, ui-sans-serif, system-ui, -apple-system, 'Segoe UI', Roboto, 'Helvetica Neue', Arial}
    html,body{height:100%;margin:0;background:radial-gradient(1200px 600px at 10% 10%, rgba(124,58,237,0.14), transparent),radial-gradient(1000px 500px at 90% 90%, rgba(6,182,212,0.10), transparent),var(--bg1);color:#e6eef8}

    /* Decorative floating blobs */
    .blob{position:absolute;border-radius:50%;filter:blur(60px);opacity:0.45;transform:translate3d(0,0,0);mix-blend-mode:screen}
    .blob.a{width:420px;height:420px;left:-80px;top:-60px;background:linear-gradient(120deg,var(--accent),transparent)}
    .blob.b{width:320px;height:320px;right:-60px;bottom:-80px;background:linear-gradient(120deg,var(--accent2),transparent)}

    .wrap{min-height:100vh;display:grid;place-items:center;padding:3rem}
    .card{width:100%;max-width:960px;background:transparent;display:grid;grid-template-columns:420px 1fr;border-radius:18px;overflow:hidden;backdrop-filter: blur(6px) saturate(1.05);box-shadow: 0 10px 40px rgba(2,6,23,0.75);position:relative}

    .left{padding:40px;background:linear-gradient(180deg,rgba(255,255,255,0.02),rgba(255,255,255,0.01));border-right:1px solid rgba(255,255,255,0.03);display:flex;flex-direction:column;gap:18px}
    .brand{display:flex;align-items:center;gap:14px}
    .logo{width:56px;height:56px;border-radius:12px;background:linear-gradient(135deg,var(--accent),var(--accent2));display:grid;place-items:center;font-weight:700;color:#fff}
    .brand h1{margin:0;font-size:18px;letter-spacing:0.4px}
    .brand p{margin:0;font-size:13px;color:rgba(230,238,248,0.8)}

    .left .info{margin-top:6px;font-size:13px;color:rgba(230,238,248,0.8);line-height:1.45}

    /* decorative key visual */
    .left .visual{flex:1;display:grid;place-items:center}
    .chip{width:220px;height:130px;border-radius:12px;background:linear-gradient(90deg, rgba(255,255,255,0.03), rgba(255,255,255,0.01));padding:14px;box-shadow: inset 0 1px 0 rgba(255,255,255,0.02)}
    .chip strong{display:block;font-size:16px}
    .chip small{display:block;opacity:0.6;margin-top:6px}

    .right{padding:42px 48px;display:flex;flex-direction:column;gap:18px;background:linear-gradient(180deg, rgba(255,255,255,0.01), rgba(255,255,255,0.00));}

    form{display:flex;flex-direction:column;gap:14px;max-width:420px}
    label{font-size:12px;color:rgba(230,238,248,0.8)}
    input[type="text"],input[type="password"]{width:100%;padding:12px 14px;border-radius:10px;border:1px solid rgba(255,255,255,0.05);background:rgba(255,255,255,0.02);color:inherit;outline:none;transition:box-shadow .18s,transform .12s}
    input:focus{box-shadow:0 6px 18px rgba(2,6,23,0.6);transform:translateY(-2px)}
    .controls{display:flex;align-items:center;justify-content:space-between;margin-top:6px}
    .btn{display:inline-flex;align-items:center;gap:10px;padding:11px 16px;border-radius:12px;border:0;background:linear-gradient(90deg,var(--accent),var(--accent2));color:white;font-weight:600;cursor:pointer;box-shadow:0 6px 18px rgba(124,58,237,0.18)}

    .muted{font-size:13px;color:rgba(230,238,248,0.6)}
    .err{background:rgba(255,0,0,0.07);padding:10px;border-radius:8px;border:1px solid rgba(255,0,0,0.08);color:#ffdddd}

    .foot{margin-top:auto;font-size:12px;color:rgba(230,238,248,0.6)}

    /* small screens */
    @media (max-width:880px){
      .card{grid-template-columns:1fr;max-width:520px}
      .left{order:2;padding:20px}
      .right{order:1;padding:28px}
    }
  </style>
</head>
<body>
  <div class="blob a" aria-hidden></div>
  <div class="blob b" aria-hidden></div>
  <div class="wrap">
    <div class="card" role="region" aria-label="Admin login">
      <div class="left">
        <div class="brand">
          <div class="logo">AD</div>
          <div>
            <h1>Admin Login</h1>
            <p>Control panel · Secure access</p>
          </div>
        </div>

        <div class="info">
          <p>Welcome back. Use your administrator credentials to sign in. This interface is intentionally minimal — focused on clarity and quick access.</p>
        </div>

        <div class="visual">
          <div class="chip" aria-hidden>
            <strong>Server Status: <span style="color: #9fe6ff;">OK</span></strong>
            <small>Last check: <?php echo date('Y-m-d H:i:s'); ?></small>
          </div>
        </div>

        <div class="foot">© <?php echo date('Y'); ?> Admin — Confidential access only.</div>
      </div>

      <div class="right">
        <h2 style="margin:0;font-size:20px">Sign in to Admin</h2>
        <p class="muted">Enter your administrator username and password.</p>

        <?php if (!empty($errors)): ?>
          <div class="err" role="alert">
            <?php echo htmlspecialchars(implode('<br>', $errors)); ?>
          </div>
        <?php endif; ?>

        <form method="post" novalidate>
          <div>
            <label for="username">Username</label>
            <input id="username" name="username" type="text" autocomplete="username" placeholder="admin" required>
          </div>

          <div>
            <label for="password">Password</label>
            <div style="position:relative">
              <input id="password" name="password" type="password" autocomplete="current-password" placeholder="••••••••" required>
              <button type="button" id="toggle" title="Show password" style="position:absolute;right:8px;top:8px;padding:6px;border-radius:8px;border:0;background:transparent;color:rgba(230,238,248,0.6);cursor:pointer">👁️</button>
            </div>
          </div>

         

          <div style="margin-top:6px;display:flex;gap:12px;align-items:center">
            <button class="btn" type="submit">Sign in</button>
          </div>
        </form>

      
      </div>
    </div>
  </div>

  <script>
    // Toggle password visibility
    (function(){
      const pw = document.getElementById('password');
      const btn = document.getElementById('toggle');
      btn.addEventListener('click', function(){
        if (pw.type === 'password') { pw.type = 'text'; btn.textContent = '🙈'; btn.title = 'Hide password'; }
        else { pw.type = 'password'; btn.textContent = '👁️'; btn.title = 'Show password'; }
      });

      // small progressive enhancement: focus the username field
      document.getElementById('username').focus();
    })();
  </script>
</body>
</html>
