<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>About Us - Uncommon Learning Standard</title>
  <meta name="description" content="Learn more about Uncommon Learning Standard (ULS) - simplifying psychology, sociology, and beyond.">
  <meta name="keywords" content="About, ULS, Education, Psychology, Sociology">

  <!-- Favicons -->
  <link href="logo.png" rel="icon">
  <link href="logo.png" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&family=EB+Garamond:wght@400;600;700&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="assets/css/main.css" rel="stylesheet">

</head>

<body class="about-page">

 <?php include("header.php"); ?>

  <main class="main">

    <!-- Page Title -->
    <div class="page-title">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0">About Us</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="index.php">Home</a></li>
            <li class="current">About</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- About Section -->
    <section id="about" class="about section">
      <div class="container" data-aos="fade-up">

        <div class="row gy-4">
          <div class="col-lg-6">
            <img src="https://defaultcustomheadersdata.files.wordpress.com/2016/07/design2.jpg?resize=2000,800" style="width: 100%; height: 100%;" class="img-fluid rounded-3 shadow" alt="About ULS">
          </div>

          <div class="col-lg-6 d-flex flex-column justify-content-center">
            <h2 class="fw-bold">ABOUT UNCOMMON LEARNING STANDARD (ULS)</h2>
            <p>
              Uncommon Learning Standard (ULS) is an educational hub created to simplify complex knowledge in psychology, sociology, and beyond. 
              Our goal is to make learning clear, engaging, and accessible for students and curious minds.
            </p>

            <h3 class="mt-4">Why ULS Exists</h3>
            <p>
              Instead of drowning in jargon, we break ideas down into clear, useful lessons that you can actually apply in real life.
            </p>

            <h3 class="mt-4">What Makes ULS Different</h3>
            <p>
              We believe knowledge should be practical and enjoyable. At ULS, we transform complex concepts into simple insights that spark curiosity and action.
            </p>

            <div class="mt-4">
              <a href="index.php" class="btn btn-primary px-4 py-2">Start Reading</a>
              <a href="contact.php" class="btn btn-outline-dark px-4 py-2">Support Us</a>
            </div>
          </div>
        </div>
      </div>
    </section><!-- /About Section -->

    <!-- Mission & Vision Section -->
    <section class="section bg-light py-5">
      <div class="container" data-aos="fade-up">
        <div class="row">
          <div class="col-lg-6">
            <h2 class="fw-bold">Our Mission</h2>
            <p>
              To make knowledge simple, accessible, and life-changing by breaking down academic concepts into clear, engaging lessons that inspire action.
            </p>
          </div>
          <div class="col-lg-6">
            <h2 class="fw-bold">Our Vision</h2>
            <p>
              To be the leading global hub for simplified education, empowering learners to apply knowledge in real-world situations and spark innovation.
            </p>
          </div>
        </div>
      </div>
    </section>

    <!-- Core Values -->
    <section class="section py-5">
      <div class="container" data-aos="fade-up">
        <h2 class="fw-bold text-center mb-4">Our Core Values</h2>
        <div class="row gy-4 text-center">
          <div class="col-lg-3 col-md-6">
            <i class="bi bi-lightbulb display-5 text-primary"></i>
            <h5 class="mt-3">Clarity</h5>
            <p>We make complex topics simple and easy to understand.</p>
          </div>
          <div class="col-lg-3 col-md-6">
            <i class="bi bi-people display-5 text-success"></i>
            <h5 class="mt-3">Community</h5>
            <p>We foster a supportive space for curious learners.</p>
          </div>
          <div class="col-lg-3 col-md-6">
            <i class="bi bi-book display-5 text-danger"></i>
            <h5 class="mt-3">Knowledge</h5>
            <p>We value accurate, practical, and engaging insights.</p>
          </div>
          <div class="col-lg-3 col-md-6">
            <i class="bi bi-globe display-5 text-warning"></i>
            <h5 class="mt-3">Accessibility</h5>
            <p>We believe education should be available to everyone.</p>
          </div>
        </div>
      </div>
    </section>

    <!-- Team Section -->
    <section class="section bg-light py-5">
      <div class="container" data-aos="fade-up">
        <h2 class="fw-bold text-center mb-5">Meet Our Team</h2>
        <div class="row gy-4">
          <div class="col-lg-4 text-center">
            <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTNiAaKk2O5kUsjqJP01k24EW93PnSHjuJLTA&s" class="rounded-circle mb-3" alt="Founder">
            <h5>Odia Owen</h5>
            <p>Founder & Lead Educator</p>
          </div>
          <div class="col-lg-4 text-center">
            <img src="https://media.istockphoto.com/id/1310533180/photo/cheerful-fashionable-adult-man-in-city-setting.jpg?s=612x612&w=0&k=20&c=hfy_5L8llmz_sUp1_n1NbM5Gsyk0kUbJRmR3TXAaoMM=" class="rounded-circle mb-3" alt="Team">
            <h5>Jane Smith</h5>
            <p>Content Strategist</p>
          </div>
          <div class="col-lg-4 text-center">
            <img src="https://static.vecteezy.com/system/resources/thumbnails/005/346/410/small_2x/close-up-portrait-of-smiling-handsome-young-caucasian-man-face-looking-at-camera-on-isolated-light-gray-studio-background-photo.jpg" class="rounded-circle mb-3" alt="Team">
            <h5>Michael Johnson</h5>
            <p>Research & Development</p>
          </div>
        </div>
      </div>
    </section>

    <!-- Testimonials -->
    <section class="section py-5">
      <div class="container" data-aos="fade-up">
        <h2 class="fw-bold text-center mb-5">What Our Readers Say</h2>
        <div class="row gy-4">
          <div class="col-md-4">
            <div class="p-4 border rounded shadow-sm">
              <p>"ULS has made learning psychology so much easier. I can now understand concepts I struggled with for years!"</p>
              <h6>- Sarah, Student</h6>
            </div>
          </div>
          <div class="col-md-4">
            <div class="p-4 border rounded shadow-sm">
              <p>"This platform is revolutionary. The breakdown of topics is simple, practical, and engaging."</p>
              <h6>- Daniel, Teacher</h6>
            </div>
          </div>
          <div class="col-md-4">
            <div class="p-4 border rounded shadow-sm">
              <p>"Finally, an educational hub that doesn’t feel intimidating. I love the community here."</p>
              <h6>- Maria, Lifelong Learner</h6>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Call to Action -->
    <section class="section bg-primary text-white text-center py-5">
      <div class="container" data-aos="fade-up">
        <h2 class="fw-bold">Discover a World of Possibilities</h2>
        <p class="lead">Join thousands of readers exploring knowledge in a smarter way. Start learning today!</p>
        <a href="index.php" class="btn btn-light px-4 py-2 mt-3">Get Started</a>
      </div>
    </section>

  </main>

 <?php include("footer.php"); ?>

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
  </a>

  <!-- Preloader -->
  <div id="preloader"></div>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/vendor/aos/aos.js"></script>
  <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>

  <!-- Main JS File -->
  <script src="assets/js/main.js"></script>

</body>
</html>
